package org.dromara.zjk.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.IdUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import lombok.RequiredArgsConstructor;
import org.dromara.common.core.constant.TenantConstants;
import org.dromara.common.core.utils.MapstructUtils;
import org.dromara.common.core.utils.StringUtils;
import org.dromara.common.mybatis.core.page.PageQuery;
import org.dromara.common.mybatis.core.page.TableDataInfo;
import org.dromara.common.satoken.utils.LoginHelper;
import org.dromara.zjk.domain.LearningBack;
import org.dromara.zjk.domain.bo.LearningBackBo;
import org.dromara.zjk.domain.vo.LearningBackVo;
import org.dromara.zjk.mapper.LearningBackMapper;
import org.dromara.zjk.mapper.ZjkExpertMapper;
import org.dromara.zjk.service.ILearningBackService;
import org.springframework.stereotype.Service;

import java.util.Collection;
import java.util.List;
import java.util.Map;

/**
 * 【请填写功能名称】Service业务层处理
 *
 * @author ygh
 * @date 2025-07-28
 */
@RequiredArgsConstructor
@Service
public class LearningBackServiceImpl implements ILearningBackService {

    private final LearningBackMapper baseMapper;
    private final ZjkExpertMapper zjkExpertMapper;

    /**
     * 查询【请填写功能名称】
     *
     * @param ID 主键
     * @return 【请填写功能名称】
     */
    @Override
    public LearningBackVo queryById(String ID) {
        return baseMapper.selectVoById(ID);
    }

    /**
     * 分页查询【请填写功能名称】列表
     *
     * @param bo        查询条件
     * @param pageQuery 分页参数
     * @return 【请填写功能名称】分页列表
     */
    @Override
    public TableDataInfo<LearningBackVo> queryPageList(LearningBackBo bo, PageQuery pageQuery) {
        boolean contains = LoginHelper.getLoginUser().getRolePermission().contains(TenantConstants.EXPERT_ROLE_KEY);
        if (contains) {
            bo.setCreateBy(LoginHelper.getUserId());
        }
        Page<LearningBackVo> result = new Page<>();
        LambdaQueryWrapper<LearningBack> lqw = buildQueryWrapper(bo);
        if (!StringUtils.isEmpty(bo.getExpertName())) {
            List<Long> uids = zjkExpertMapper.selectIdsByName(bo.getExpertName());
            if (!CollectionUtil.isEmpty(uids)) {
                lqw.in(LearningBack::getCreateBy, uids);
            }else{
                return TableDataInfo.build(result);
            }
        }
        lqw.orderByDesc(LearningBack::getCreateTime);
        result = baseMapper.selectVoPage(pageQuery.build(), lqw);
        result.getRecords().stream().forEach(o -> {
            o.setExpertName(zjkExpertMapper.selectByUserId(o.getCreateBy()).getExpertName());

        });
        return TableDataInfo.build(result);
    }

    /**
     * 查询符合条件的【请填写功能名称】列表
     *
     * @param bo 查询条件
     * @return 【请填写功能名称】列表
     */
    @Override
    public List<LearningBackVo> queryList(LearningBackBo bo) {
        bo.setCreateBy(LoginHelper.getUserId());
        LambdaQueryWrapper<LearningBack> lqw = buildQueryWrapper(bo);
        return baseMapper.selectVoList(lqw);
    }

    private LambdaQueryWrapper<LearningBack> buildQueryWrapper(LearningBackBo bo) {
        Map<String, Object> params = bo.getParams();
        LambdaQueryWrapper<LearningBack> lqw = Wrappers.lambdaQuery();
        lqw.eq(StringUtils.isNotBlank(bo.getID()), LearningBack::getID, bo.getID());
        lqw.like(StringUtils.isNotBlank(bo.getBackName()), LearningBack::getBackName, bo.getBackName());
        lqw.eq(StringUtils.isNotBlank(bo.getBackContent()), LearningBack::getBackContent, bo.getBackContent());
        lqw.eq(bo.getCreateBy() != null, LearningBack::getCreateBy, bo.getCreateBy());
        lqw.eq(bo.getCreateTime() != null, LearningBack::getCreateTime, bo.getCreateTime());
        lqw.eq(bo.getUpdateBy() != null, LearningBack::getUpdateBy, bo.getUpdateBy());
        lqw.eq(bo.getUpdateTime() != null, LearningBack::getUpdateTime, bo.getUpdateTime());
        return lqw;
    }

    /**
     * 新增【请填写功能名称】
     *
     * @param bo 【请填写功能名称】
     * @return 是否新增成功
     */
    @Override
    public Boolean insertByBo(LearningBackBo bo) {
        LearningBack add = MapstructUtils.convert(bo, LearningBack.class);
        validEntityBeforeSave(add);
        boolean flag = baseMapper.insert(add) > 0;
        if (flag) {
            bo.setID(add.getID());
        }
        return flag;
    }

    /**
     * 修改【请填写功能名称】
     *
     * @param bo 【请填写功能名称】
     * @return 是否修改成功
     */
    @Override
    public Boolean updateByBo(LearningBackBo bo) {
        LearningBack update = MapstructUtils.convert(bo, LearningBack.class);
        validEntityBeforeSave(update);
        return baseMapper.updateById(update) > 0;
    }

    /**
     * 保存前的数据校验
     */
    private void validEntityBeforeSave(LearningBack entity) {
        //TODO 做一些数据校验,如唯一约束
        // 如果ID为空，生成新的ID
        if (StringUtils.isBlank(entity.getID())) {
            entity.setID(IdUtil.simpleUUID()); // 或使用其他ID生成方式
        }
    }

    /**
     * 校验并批量删除【请填写功能名称】信息
     *
     * @param ids     待删除的主键集合
     * @param isValid 是否进行有效性校验
     * @return 是否删除成功
     */
    @Override
    public Boolean deleteWithValidByIds(Collection<String> ids, Boolean isValid) {
        if (isValid) {
            //TODO 做一些业务上的校验,判断是否需要校验
        }
        return baseMapper.deleteByIds(ids) > 0;
    }


}
