package org.dromara.zjk.service.impl;

import org.dromara.common.core.domain.R;
import org.dromara.common.core.utils.MapstructUtils;
import org.dromara.common.core.utils.StringUtils;
import org.dromara.common.mybatis.core.page.TableDataInfo;
import org.dromara.common.mybatis.core.page.PageQuery;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import lombok.RequiredArgsConstructor;
import org.dromara.zjk.domain.ZjkCreditUser;
import org.dromara.zjk.domain.dto.CreditReqDto;
import org.dromara.zjk.domain.vo.ZjkCreditUserVo;
import org.dromara.zjk.mapper.ZjkCreditMapper;
import org.dromara.zjk.mapper.ZjkCreditUserMapper;
import org.springframework.stereotype.Service;
import org.dromara.zjk.domain.bo.ZjkCreditLvBo;
import org.dromara.zjk.domain.vo.ZjkCreditLvVo;
import org.dromara.zjk.domain.ZjkCreditLv;
import org.dromara.zjk.mapper.ZjkCreditLvMapper;
import org.dromara.zjk.service.IZjkCreditLvService;

import java.util.List;
import java.util.Map;
import java.util.Collection;

/**
 * 【请填写功能名称】Service业务层处理
 *
 * @author ygh
 * @date 2024-11-13
 */
@RequiredArgsConstructor
@Service
public class ZjkCreditLvServiceImpl implements IZjkCreditLvService {

    private final ZjkCreditLvMapper baseMapper;

    private final ZjkCreditUserMapper zjkCreditUserMapper;
    private final ZjkCreditMapper zjkCreditMapper;
    /**
     * 查询【请填写功能名称】
     *
     * @param id 主键
     * @return 【请填写功能名称】
     */
    @Override
    public ZjkCreditLvVo queryById(Long id){
        return baseMapper.selectVoById(id);
    }

    /**
     * 分页查询【请填写功能名称】列表
     *
     * @param bo        查询条件
     * @param pageQuery 分页参数
     * @return 【请填写功能名称】分页列表
     */
    @Override
    public List<ZjkCreditLvVo> queryPageList() {
        LambdaQueryWrapper<ZjkCreditLv> lqw = new LambdaQueryWrapper<>();
        lqw.orderBy(true,true,ZjkCreditLv::getId);
        List<ZjkCreditLvVo> zjkCreditLvs = baseMapper.selectVoList(lqw);
        for (ZjkCreditLvVo zjkCreditLv : zjkCreditLvs) {
            Long creditSectionGe = zjkCreditLv.getCreditSectionGe();
            Long creditSectionLe = zjkCreditLv.getCreditSectionLe();
            CreditReqDto creditReqDto = new CreditReqDto();
            creditReqDto.setCredtieGe(creditSectionGe);
            creditReqDto.setCrediteLe(creditSectionLe);
            Integer pointCount = zjkCreditMapper.getPointCount(creditReqDto);
            zjkCreditLv.setPersonSum(Long.valueOf(pointCount));
        }
        return zjkCreditLvs;
    }





    /**
     * 查询符合条件的【请填写功能名称】列表
     *
     * @param bo 查询条件
     * @return 【请填写功能名称】列表
     */
    @Override
    public List<ZjkCreditLvVo> queryList(ZjkCreditLvBo bo) {
        LambdaQueryWrapper<ZjkCreditLv> lqw = buildQueryWrapper(bo);
        return baseMapper.selectVoList(lqw);
    }

    private LambdaQueryWrapper<ZjkCreditLv> buildQueryWrapper(ZjkCreditLvBo bo) {
        Map<String, Object> params = bo.getParams();
        LambdaQueryWrapper<ZjkCreditLv> lqw = Wrappers.lambdaQuery();
        lqw.like(StringUtils.isNotBlank(bo.getCreditName()), ZjkCreditLv::getCreditName, bo.getCreditName());
        lqw.eq(bo.getCreditSectionLe() != null, ZjkCreditLv::getCreditSectionLe, bo.getCreditSectionLe());
        lqw.eq(bo.getCreditSectionGe() != null, ZjkCreditLv::getCreditSectionGe, bo.getCreditSectionGe());
        return lqw;
    }

    /**
     * 新增【请填写功能名称】
     *
     * @param bo 【请填写功能名称】
     * @return 是否新增成功
     */
    @Override
    public Boolean insertByBo(ZjkCreditLvBo bo) {
        ZjkCreditLv add = MapstructUtils.convert(bo, ZjkCreditLv.class);
        validEntityBeforeSave(add);
        boolean flag = baseMapper.insert(add) > 0;
        if (flag) {
            bo.setId(add.getId());
        }
        return flag;
    }

    /**
     * 修改【请填写功能名称】
     *
     * @param bo 【请填写功能名称】
     * @return 是否修改成功
     */
    @Override
    public Boolean updateByBo(ZjkCreditLvBo bo) {
        ZjkCreditLv update = MapstructUtils.convert(bo, ZjkCreditLv.class);
        validEntityBeforeSave(update);
        return baseMapper.updateById(update) > 0;
    }

    /**
     * 保存前的数据校验
     */
    private void validEntityBeforeSave(ZjkCreditLv entity){
        //TODO 做一些数据校验,如唯一约束
    }

    /**
     * 校验并批量删除【请填写功能名称】信息
     *
     * @param ids     待删除的主键集合
     * @param isValid 是否进行有效性校验
     * @return 是否删除成功
     */
    @Override
    public Boolean deleteWithValidByIds(Collection<Long> ids, Boolean isValid) {
        if(isValid){
            //TODO 做一些业务上的校验,判断是否需要校验
        }
        return baseMapper.deleteByIds(ids) > 0;
    }

    @Override
    public List<ZjkCreditUserVo> countReson(ZjkCreditLvVo zjkCreditLvVo) {
        LambdaQueryWrapper<ZjkCreditUser> lambdaQueryWrapper = new LambdaQueryWrapper<>();
        lambdaQueryWrapper.ge(ZjkCreditUser::getCreditCount,zjkCreditLvVo.getCreditSectionLe());
        lambdaQueryWrapper.le(ZjkCreditUser::getCreditCount,zjkCreditLvVo.getCreditSectionGe());
        List<ZjkCreditUserVo> list = zjkCreditUserMapper.selectVoList(lambdaQueryWrapper);
        return list;
    }
}
