package org.dromara.zjk.task;

import jakarta.annotation.PostConstruct;
import lombok.extern.slf4j.Slf4j;
import org.dromara.zjk.annualInspection.annualInspectionAudit.service.IZjkAnnualInspectionService;
import org.dromara.zjk.config.CronConfig;
import org.dromara.zjk.learning_world.job.ActivityJobService;
import org.dromara.zjk.service.IZjkExpertItemService;
import org.dromara.zjk.service.ZjkExpertChartService;
import org.dromara.zjk.service.ZjkInvoiceReportService;
import org.dromara.zjk.service.ZjkPointUserService;
import org.dromara.zjk.statement.service.IZjkMoneyStatementService;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.SchedulingConfigurer;
import org.springframework.scheduling.config.ScheduledTaskRegistrar;
import org.springframework.scheduling.support.CronTrigger;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;

/**
 * 定时任务
 *
 * @author : yanguohua
 * @version : 1.0
 * @date : 2024/3/22 10:35
 */
@Slf4j
@Component
@EnableScheduling
public class DynamicCronTask implements SchedulingConfigurer {
    @Resource
    private ZjkPointUserService zjkPointUserService;
    @Resource
    private CronConfig config;
    @Resource
    private ActivityJobService jobService;
    @Resource
    private ZjkExpertChartService zjkExpertChartService;
    @Resource
    private IZjkAnnualInspectionService zjkAnnualInspectionService;
    @Resource
    private IZjkMoneyStatementService zjkMoneyStatementService;

    @Resource
    private IZjkExpertItemService zjkExpertItemService;
    @Resource
    private ZjkInvoiceReportService zjkInvoiceReportService;
    @Override
    public void configureTasks(ScheduledTaskRegistrar taskRegistrar) {
        taskRegistrar.addTriggerTask(() -> {
            zjkPointUserService.handleWaitCheckPointStatus();
        }, triggerContext -> new CronTrigger(config.refreshCheckPoint).nextExecutionTime(triggerContext).toInstant());
        taskRegistrar.addTriggerTask(() -> {
            jobService.startActivity();
        }, triggerContext -> new CronTrigger(config.activityStartCheckPoint).nextExecutionTime(triggerContext).toInstant());
        taskRegistrar.addTriggerTask(() -> {
            jobService.endActivity();
        }, triggerContext -> new CronTrigger(config.activityEndCheckPoint).nextExecutionTime(triggerContext).toInstant());
        taskRegistrar.addTriggerTask(() -> {
            zjkExpertChartService.handleExpertChart();
        }, triggerContext -> new CronTrigger(config.refreshExpertChart).nextExecutionTime(triggerContext).toInstant());
        taskRegistrar.addTriggerTask(() -> {
            zjkMoneyStatementService.addYear();
        }, triggerContext -> new CronTrigger(config.statementYearInspection).nextExecutionTime(triggerContext).toInstant());
        taskRegistrar.addTriggerTask(() -> {
            zjkMoneyStatementService.insertByBo();
        }, triggerContext -> new CronTrigger(config.statementInspection).nextExecutionTime(triggerContext).toInstant());
        taskRegistrar.addTriggerTask(() -> {
            zjkAnnualInspectionService.executeAnnualInspection();
        }, triggerContext -> new CronTrigger(config.annualInspection).nextExecutionTime(triggerContext).toInstant());
        taskRegistrar.addTriggerTask(() -> {
            zjkExpertItemService.cancelExpert();
        }, triggerContext -> new CronTrigger(config.cancelExpertInspection).nextExecutionTime(triggerContext).toInstant());
        taskRegistrar.addTriggerTask(() -> {
            zjkInvoiceReportService.handleInvoiceReport(0);
        }, triggerContext -> new CronTrigger(config.invoiceReportMonth).nextExecutionTime(triggerContext).toInstant());
        taskRegistrar.addTriggerTask(() -> {
            zjkInvoiceReportService.handleInvoiceReport(1);
        }, triggerContext -> new CronTrigger(config.invoiceReportYear).nextExecutionTime(triggerContext).toInstant());
    }

}
