/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.plugin.control.tps;

import com.alibaba.nacos.plugin.control.Loggers;
import com.alibaba.nacos.plugin.control.tps.TpsControlManager;
import com.alibaba.nacos.plugin.control.tps.barrier.TpsBarrier;
import com.alibaba.nacos.plugin.control.tps.request.TpsCheckRequest;
import com.alibaba.nacos.plugin.control.tps.response.TpsCheckResponse;
import com.alibaba.nacos.plugin.control.tps.rule.TpsControlRule;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class DefaultTpsControlManager
extends TpsControlManager {
    protected final Map<String, TpsBarrier> points = new ConcurrentHashMap<String, TpsBarrier>(16);
    protected final Map<String, TpsControlRule> rules = new ConcurrentHashMap<String, TpsControlRule>(16);

    @Override
    public synchronized void registerTpsPoint(String pointName) {
        if (!this.points.containsKey(pointName)) {
            this.points.put(pointName, this.tpsBarrierCreator.createTpsBarrier(pointName));
            if (this.rules.containsKey(pointName)) {
                this.points.get(pointName).applyRule(this.rules.get(pointName));
            } else {
                this.initTpsRule(pointName);
            }
        }
        Loggers.CONTROL.warn("Tps point for {} registered, But tps control manager is no limit implementation.", (Object)pointName);
    }

    @Override
    public synchronized void applyTpsRule(String pointName, TpsControlRule rule) {
        if (rule == null) {
            this.rules.remove(pointName);
        } else {
            this.rules.put(pointName, rule);
        }
        if (this.points.containsKey(pointName)) {
            this.points.get(pointName).applyRule(rule);
        }
        Loggers.CONTROL.warn("Tps rule for point name {} updated, But tps control manager is no limit implementation.", (Object)pointName);
    }

    @Override
    public Map<String, TpsBarrier> getPoints() {
        return this.points;
    }

    @Override
    public Map<String, TpsControlRule> getRules() {
        return this.rules;
    }

    @Override
    public TpsCheckResponse check(TpsCheckRequest tpsRequest) {
        return new TpsCheckResponse(true, 100, "skip");
    }

    @Override
    public String getName() {
        return "noLimit";
    }
}

