package org.dromara.common.sms.client;

import jakarta.xml.soap.SOAPConnection;
import jakarta.xml.soap.SOAPException;
import jakarta.xml.soap.SOAPMessage;

import java.io.IOException;
import java.net.*;

public class SOAPConnectionWare {

	private SOAPConnection connection;

	public SOAPConnectionWare(SOAPConnection connection){
		this.connection = connection;
	}

	public SOAPMessage call(SOAPMessage request, String url) throws SOAPException, MalformedURLException{
		URL endpoints = new URL(null,url,new URLStreamHandler(){
			@Override
			protected URLConnection openConnection(URL url) throws IOException {
				URL clone_url = new URL(url.toString());
                HttpURLConnection clone_urlconnection = (HttpURLConnection) clone_url.openConnection();
                clone_urlconnection.setConnectTimeout(3000);
                clone_urlconnection.setReadTimeout(3000);
                clone_urlconnection.setDoInput(false);
                return(clone_urlconnection);
			}

		});
		return connection.call(request, endpoints);
	}

	public SOAPMessage call(SOAPMessage request, String url,final int timeout) throws SOAPException, MalformedURLException{
		URL endpoints = new URL(null,url,new URLStreamHandler(){
			@Override
			protected URLConnection openConnection(URL url) throws IOException {
				URL clone_url = new URL(url.toString());
                HttpURLConnection clone_urlconnection = (HttpURLConnection) clone_url.openConnection();
                clone_urlconnection.setConnectTimeout(timeout);
                clone_urlconnection.setReadTimeout(timeout);
                clone_urlconnection.setDoInput(false);
                return(clone_urlconnection);
			}

		});
		return connection.call(request, endpoints);
	}

	public void close() throws SOAPException{
		connection.close();
	}

}
