package org.dromara.zjk.domain;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;

import java.math.BigDecimal;
import java.util.Date;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;
import lombok.Data;
import org.dromara.common.mybatis.core.domain.BaseEntity;
import org.dromara.common.sensitive.annotation.Sensitive;
import org.dromara.common.sensitive.core.SensitiveStrategy;
import org.dromara.common.tenant.core.TenantEntity;
import org.dromara.zjk.zwy.annotation.EncryptSensitive;
import org.springframework.format.annotation.DateTimeFormat;

/**
 * 专家费用管理表
 * @TableName zjk_expert_money_info
 */
@TableName(value ="zjk_expert_money_info")
@Data
public class ZjkExpertMoneyInfo extends TenantEntity {
    /**
     * 主键
     */
    @TableId(value = "money_id",type = IdType.ASSIGN_ID)
    private Long moneyId;

    /**
     * 专家类型
     */
    @TableField(value = "expert_type")
    private String expertType;

    /**
     * 专家ID
     */
    @TableField(value = "expert_id")
    private String expertId;

    /**
     * 专家费金额
     */
    @TableField(value = "expert_money")
    private BigDecimal expertMoney;

    /**
     * 未支付金额
     */
    private BigDecimal expertNoPayMoney;

    /**
     * 已支付金额
     */
    private BigDecimal expertPayMoney;
    /**
     * 专家姓名
     */
    @TableField(value = "expert_name")
    private String expertName;

    /**
     * 专家单位
     */
    @TableField(value = "expert_unit")
    private String expertUnit;

    /**
     * 租户号
     */
    @TableField(value = "tenant_id")
    private String tenantId;

    /**
     * 逻辑删除标志（0为正常，2为已删除）
     */
    @TableField(value = "ASSIGN_ID")
    private Object assignId;


    /**
     * 备注
     */
    @TableField(value = "remark")
    private String remark;

    /**
     * 是否支付(已支付，未支付)
     */
    @TableField(value = "expert_money_flag")
    private String expertMoneyFlag;

    /**
     * 支付凭证上传附件
     */
    @TableField(value = "expert_money_file")
    private String expertMoneyFile;

    /**
     * 项目ID
     */
    @TableField(value = "product_id")
    private String productId;

    /**
     * 项目阶段
     */
    @TableField(value = "product_type")
    private String productType;

    /**
     * 项目名称
     */
    @TableField(value = "product_name")
    private String productName;

    /**
     * 服务日期
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone="GMT+8")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date reviewDate;

    /**
     * 结算日期
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone="GMT+8")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date settlementDate;

    /**
     * 结算单号
     */
    private String settlementSn;

    /**
     * 费用单号
     */
    private String paySn;

    /**
     * 是否结算
     */
    private String status;

    /**
     * 费用
     */
    private BigDecimal expertTypeMoneyFee;

    /**
     * 身份证
     */

    @EncryptSensitive
    private String expertIdcard;
    /**
     * 联系方式
     */

    @EncryptSensitive
    private String expertContact;
    /**
     * 评审次数
     */
    private String reviewCount;

    /**
     * 结算周期
     */
    private String moneyCycle;
    /**
     * 支付方式
     */
    private String payMethod;


    @TableField(exist = false)
    private static final long serialVersionUID = 1L;
}
