package org.dromara.zjk.domain.bo;

import org.dromara.zjk.domain.ZjkCredit;
import org.dromara.common.mybatis.core.domain.BaseEntity;
import org.dromara.common.core.validate.AddGroup;
import org.dromara.common.core.validate.EditGroup;
import io.github.linpeilie.annotations.AutoMapper;
import lombok.Data;
import lombok.EqualsAndHashCode;
import jakarta.validation.constraints.*;

/**
 * 信用记录业务对象 zjk_credit
 *
 * @author ygh
 * @date 2024-11-11
 */
@Data
@EqualsAndHashCode(callSuper = true)
@AutoMapper(target = ZjkCredit.class, reverseConvertGenerate = false)
public class ZjkCreditBo extends BaseEntity {

    /**
     * 租户号
     */
    private Long creditId;

    /**
     * 信用数值
     */
    private Long credit;

    /**
     * 信用事由外键
     */
    private Long ruleId;

    /**
     * 专家id
     */
    private Long expertId;

    /**
     * 用户id
     */
    private Long userId;

    private String startTime;

    private String endTime;

    private String expertName;

    private String workUnit;

    private String parkName;

    /**
    * 数据编号
    * */
    private Long dataNumber;

    private String integralReason;


}
