package org.dromara.zjk.domain.bo;

import org.dromara.zjk.domain.ZjkExpertHistory;
import org.dromara.common.mybatis.core.domain.BaseEntity;
import org.dromara.common.core.validate.AddGroup;
import org.dromara.common.core.validate.EditGroup;
import io.github.linpeilie.annotations.AutoMapper;
import lombok.Data;
import lombok.EqualsAndHashCode;
import jakarta.validation.constraints.*;

/**
 * 专家记录变更历史表业务对象 zjk_expert_history
 *
 * @author zhangzhou
 * @date 2024-11-02
 */
@Data
@EqualsAndHashCode(callSuper = true)
@AutoMapper(target = ZjkExpertHistory.class, reverseConvertGenerate = false)
public class ZjkExpertHistoryBo extends BaseEntity {

    /**
     * id
     */
    @NotNull(message = "id不能为空", groups = { AddGroup.class, EditGroup.class })
    private Long id;

    /**
     * 旧数据
     */
    @NotBlank(message = "旧数据不能为空", groups = { AddGroup.class, EditGroup.class })
    private String oldData;

    /**
     * 新数据
     */
    @NotBlank(message = "新数据不能为空", groups = { AddGroup.class, EditGroup.class })
    private String newData;

    /**
     * 变更字段
     */
    @NotBlank(message = "变更字段不能为空", groups = { AddGroup.class, EditGroup.class })
    private String modifiedFields;

    /**
     * 备注
     */
    @NotBlank(message = "备注不能为空", groups = { AddGroup.class, EditGroup.class })
    private String remark;

    /**
     * 是否删除
     */
    @NotNull(message = "是否删除不能为空", groups = { AddGroup.class, EditGroup.class })
    private Long deleteFlag;


}
