package org.dromara.zjk.expert.expertRecommend.service;

import org.dromara.common.mybatis.core.page.PageQuery;
import org.dromara.common.mybatis.core.page.TableDataInfo;
import org.dromara.zjk.expert.expertRecommend.domain.bo.ZjkExpertRecommendBo;
import org.dromara.zjk.expert.expertRecommend.domain.vo.ZjkExpertRecommendVo;

import java.util.Collection;
import java.util.List;

/**
 * 专家推荐信息Service接口
 *
 * @author zhangzhou
 * @date 2024-11-10
 */
public interface IZjkExpertRecommendService {

    /**
     * 查询专家推荐信息
     *
     * @param id 主键
     * @return 专家推荐信息
     */
    ZjkExpertRecommendVo queryById(Long id);

    /**
     * 分页查询专家推荐信息列表
     *
     * @param bo        查询条件
     * @param pageQuery 分页参数
     * @return 专家推荐信息分页列表
     */
    TableDataInfo<ZjkExpertRecommendVo> queryPageList(ZjkExpertRecommendBo bo, PageQuery pageQuery);



    TableDataInfo<ZjkExpertRecommendVo> queryExpertRecommendList(ZjkExpertRecommendBo bo, PageQuery pageQuery);

    /**
     * 查询符合条件的专家推荐信息列表
     *
     * @param bo 查询条件
     * @return 专家推荐信息列表
     */
    List<ZjkExpertRecommendVo> queryList(ZjkExpertRecommendBo bo);

    /**
     * 新增专家推荐信息
     *
     * @param bo 专家推荐信息
     * @return 是否新增成功
     */
    Boolean insertByBo(ZjkExpertRecommendBo bo);

    /**
     * 修改专家推荐信息
     *
     * @param bo 专家推荐信息
     * @return 是否修改成功
     */
    Boolean updateByBo(ZjkExpertRecommendBo bo);

    /**
     * 校验并批量删除专家推荐信息信息
     *
     * @param ids     待删除的主键集合
     * @param isValid 是否进行有效性校验
     * @return 是否删除成功
     */
    Boolean deleteWithValidByIds(Collection<Long> ids, Boolean isValid);
}
