package org.dromara.zjk.service;

import org.dromara.common.core.domain.R;
import org.dromara.zjk.domain.ZjkCredit;
import org.dromara.zjk.domain.dto.CreditReqDto;
import org.dromara.zjk.domain.vo.*;
import org.dromara.zjk.domain.bo.ZjkCreditBo;
import org.dromara.common.mybatis.core.page.TableDataInfo;
import org.dromara.common.mybatis.core.page.PageQuery;

import java.util.Collection;
import java.util.List;

/**
 * 信用记录Service接口
 *
 * @author ygh
 * @date 2024-11-11
 */
public interface IZjkCreditService {

    /**
     * 查询信用记录
     *
     * @param ID 主键
     * @return 信用记录
     */
    ZjkCreditVo queryById(Long ID);

    /**
     * 分页查询信用记录列表
     *
     * @param bo        查询条件
     * @param pageQuery 分页参数
     * @return 信用记录分页列表
     */
    TableDataInfo<ZjkCreditVo> queryPageList(ZjkCreditBo bo, PageQuery pageQuery);

    /**
     * 查询符合条件的信用记录列表
     *
     * @param bo 查询条件
     * @return 信用记录列表
     */
    List<ZjkCreditVo> queryList(ZjkCreditBo bo);

    /**
     * 新增信用记录
     *
     * @param bo 信用记录
     * @return 是否新增成功
     */
    Boolean insertByBo(ZjkCreditBo bo);

    /**
     * 修改信用记录
     *
     * @param bo 信用记录
     * @return 是否修改成功
     */
    Boolean updateByBo(ZjkCreditBo bo);

    /**
     * 校验并批量删除信用记录信息
     *
     * @param ids     待删除的主键集合
     * @param isValid 是否进行有效性校验
     * @return 是否删除成功
     */
    Boolean deleteWithValidByIds(Collection<Long> ids, Boolean isValid);

    R<PointExpertRankVO> expertPointRankUser();

    TableDataInfo<CreditShowVO> queryPointList(CreditReqDto bo, PageQuery pageQuery);

    R<ChartBaseCreditVO> getPointBase();

    R<ChartBaseCreditVO> synchronization();
}
