package org.dromara.zjk.service;

import org.dromara.common.mybatis.core.page.PageQuery;
import org.dromara.common.mybatis.core.page.TableDataInfo;
import org.dromara.zjk.domain.bo.ZjkExpertHistoryBo;
import org.dromara.zjk.domain.vo.ZjkExpertHistoryVo;

import java.util.Collection;
import java.util.List;

/**
 * 专家记录变更历史表Service接口
 *
 * @author zhangzhou
 * @date 2024-11-02
 */
public interface IZjkExpertHistoryService {

    /**
     * 查询专家记录变更历史表
     *
     * @param id 主键
     * @return 专家记录变更历史表
     */
    ZjkExpertHistoryVo queryById(Long id);

    /**
     * 分页查询专家记录变更历史表列表
     *
     * @param bo        查询条件
     * @param pageQuery 分页参数
     * @return 专家记录变更历史表分页列表
     */
    TableDataInfo<ZjkExpertHistoryVo> queryPageList(ZjkExpertHistoryBo bo, PageQuery pageQuery);

    /**
     * 查询符合条件的专家记录变更历史表列表
     *
     * @param bo 查询条件
     * @return 专家记录变更历史表列表
     */
    List<ZjkExpertHistoryVo> queryList(ZjkExpertHistoryBo bo);

    /**
     * 新增专家记录变更历史表
     *
     * @param bo 专家记录变更历史表
     * @return 是否新增成功
     */
    Boolean insertByBo(ZjkExpertHistoryBo bo);

    /**
     * 修改专家记录变更历史表
     *
     * @param bo 专家记录变更历史表
     * @return 是否修改成功
     */
    Boolean updateByBo(ZjkExpertHistoryBo bo);

    /**
     * 校验并批量删除专家记录变更历史表信息
     *
     * @param ids     待删除的主键集合
     * @param isValid 是否进行有效性校验
     * @return 是否删除成功
     */
    Boolean deleteWithValidByIds(Collection<Long> ids, Boolean isValid);
}
