package org.dromara.zjk.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.IdUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import lombok.RequiredArgsConstructor;
import org.dromara.common.core.utils.MapstructUtils;
import org.dromara.common.core.utils.StringUtils;
import org.dromara.common.mybatis.core.page.PageQuery;
import org.dromara.common.mybatis.core.page.TableDataInfo;
import org.dromara.zjk.domain.LearningPlan;
import org.dromara.zjk.domain.LearningPlanCourse;
import org.dromara.zjk.domain.bo.LearningPlanBo;
import org.dromara.zjk.domain.vo.LearningPlanVo;
import org.dromara.zjk.mapper.LearningPlanCourseMapper;
import org.dromara.zjk.mapper.LearningPlanMapper;
import org.dromara.zjk.service.ILearningPlanService;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 【请填写功能名称】Service业务层处理
 *
 * @author ygh
 * @date 2025-07-28
 */
@RequiredArgsConstructor
@Service
public class LearningPlanServiceImpl implements ILearningPlanService {

    private final LearningPlanMapper baseMapper;
    private final LearningPlanCourseMapper learningPlanCourseMapper;

    /**
     * 查询【请填写功能名称】
     *
     * @param id 主键
     * @return 【请填写功能名称】
     */
    @Override
    public LearningPlanVo queryById(String id) {
        String s = learningPlanCourseMapper.geCourseNamesByPlanId(id);
        LearningPlanVo learningPlanVo = baseMapper.selectVoById(id);
        if (!StringUtils.isEmpty(s)) {
            learningPlanVo.setCourseNames(Arrays.asList(s.split(",")));
        }
        return learningPlanVo;
    }

    /**
     * 分页查询【请填写功能名称】列表
     *
     * @param bo        查询条件
     * @param pageQuery 分页参数
     * @return 【请填写功能名称】分页列表
     */
    @Override
    public TableDataInfo<LearningPlanVo> queryPageList(LearningPlanBo bo, PageQuery pageQuery) {
        LambdaQueryWrapper<LearningPlan> lqw = buildQueryWrapper(bo);
        Page<LearningPlanVo> result = baseMapper.selectVoPage(pageQuery.build(), lqw);
        result.getRecords().forEach(r -> r.setStudyContent(learningPlanCourseMapper.geCourseNamesByPlanId(r.getID())));
        return TableDataInfo.build(result);
    }

    /**
     * 查询符合条件的【请填写功能名称】列表
     *
     * @param bo 查询条件
     * @return 【请填写功能名称】列表
     */
    @Override
    public List<LearningPlanVo> queryList(LearningPlanBo bo) {
        LambdaQueryWrapper<LearningPlan> lqw = buildQueryWrapper(bo);
        return baseMapper.selectVoList(lqw);
    }

    private LambdaQueryWrapper<LearningPlan> buildQueryWrapper(LearningPlanBo bo) {
        Map<String, Object> params = bo.getParams();
        LambdaQueryWrapper<LearningPlan> lqw = Wrappers.lambdaQuery();
        lqw.eq(StringUtils.isNotBlank(bo.getID()), LearningPlan::getID, bo.getID());
        lqw.like(StringUtils.isNotBlank(bo.getPlanName()), LearningPlan::getPlanName, bo.getPlanName());
        lqw.eq(bo.getStartTime() != null, LearningPlan::getStartTime, bo.getStartTime());
        lqw.eq(bo.getEndTime() != null, LearningPlan::getEndTime, bo.getEndTime());
        lqw.eq(StringUtils.isNotBlank(bo.getStudyTarget()), LearningPlan::getStudyTarget, bo.getStudyTarget());
        lqw.eq(bo.getCreateBy() != null, LearningPlan::getCreateBy, bo.getCreateBy());
        lqw.eq(bo.getCreateTime() != null, LearningPlan::getCreateTime, bo.getCreateTime());
        lqw.eq(bo.getUpdateBy() != null, LearningPlan::getUpdateBy, bo.getUpdateBy());
        lqw.eq(bo.getUpdateTime() != null, LearningPlan::getUpdateTime, bo.getUpdateTime());
        return lqw;
    }

    /**
     * 新增【请填写功能名称】
     *
     * @param bo 【请填写功能名称】
     * @return 是否新增成功
     */
    @Override
    @Transactional
    public Boolean insertByBo(LearningPlanBo bo) {
        LearningPlan add = MapstructUtils.convert(bo, LearningPlan.class);
        validEntityBeforeSave(add);
        boolean flag = baseMapper.insert(add) > 0;
        if (flag) {
            bo.setID(add.getID());
        }
        handleCourseByPlan(bo);
        return flag;
    }

    private void handleCourseByPlan(LearningPlanBo bo) {
        //处理计划课程关系
        learningPlanCourseMapper.deleteByPlanId(bo.getID());
        List<LearningPlanCourse> collect = bo.getCourseIds().stream().map(courseId -> {
            LearningPlanCourse learningPlanCourse = new LearningPlanCourse();
            learningPlanCourse.setCourseId(courseId);
            learningPlanCourse.setPlanId(bo.getID());
            return learningPlanCourse;
        }).collect(Collectors.toList());
        if (!CollectionUtil.isEmpty(collect)) {
            learningPlanCourseMapper.insertBatch(collect);
        }
    }

    /**
     * 修改【请填写功能名称】
     *
     * @param bo 【请填写功能名称】
     * @return 是否修改成功
     */
    @Override
    public Boolean updateByBo(LearningPlanBo bo) {
        LearningPlan update = MapstructUtils.convert(bo, LearningPlan.class);
        validEntityBeforeSave(update);
        //处理计划课程关系
        handleCourseByPlan(bo);
        return baseMapper.updateById(update) > 0;
    }

    /**
     * 保存前的数据校验
     */
    private void validEntityBeforeSave(LearningPlan entity) {
        //TODO 做一些数据校验,如唯一约束
        if (StringUtils.isBlank(entity.getID())) {
            entity.setID(IdUtil.simpleUUID()); // 或使用其他ID生成方式
        }
    }

    /**
     * 校验并批量删除【请填写功能名称】信息
     *
     * @param ids     待删除的主键集合
     * @param isValid 是否进行有效性校验
     * @return 是否删除成功
     */
    @Override
    public Boolean deleteWithValidByIds(Collection<String> ids, Boolean isValid) {
        if (isValid) {
            //TODO 做一些业务上的校验,判断是否需要校验
        }
        if (ids.isEmpty()) {
            return true;
        }
        ids.stream().forEach(id -> learningPlanCourseMapper.deleteByPlanId(id));
        return baseMapper.deleteByIds(ids) > 0;
    }
}
