/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.core.remote;

import com.alibaba.nacos.api.remote.RequestCallBack;
import com.alibaba.nacos.api.remote.request.ClientDetectionRequest;
import com.alibaba.nacos.api.remote.request.Request;
import com.alibaba.nacos.api.remote.response.Response;
import com.alibaba.nacos.common.remote.exception.ConnectionAlreadyClosedException;
import com.alibaba.nacos.common.utils.CollectionUtils;
import com.alibaba.nacos.core.remote.Connection;
import com.alibaba.nacos.core.remote.RuntimeConnectionEjector;
import com.alibaba.nacos.plugin.control.Loggers;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class NacosRuntimeConnectionEjector
extends RuntimeConnectionEjector {
    @Override
    public void doEject() {
        this.ejectOutdatedConnection();
        this.ejectOverLimitConnection();
    }

    private void ejectOutdatedConnection() {
        try {
            Loggers.CONNECTION.info("Connection check task start");
            Map<String, Connection> connections = this.connectionManager.connections;
            int totalCount = connections.size();
            int currentSdkClientCount = this.connectionManager.currentSdkClientCount();
            Loggers.CONNECTION.info("Long connection metrics detail ,Total count ={}, sdkCount={},clusterCount={}", new Object[]{totalCount, currentSdkClientCount, totalCount - currentSdkClientCount});
            HashSet<String> outDatedConnections = new HashSet<String>();
            long now = System.currentTimeMillis();
            for (Map.Entry<String, Connection> entry : connections.entrySet()) {
                Connection client = entry.getValue();
                if (now - client.getMetaInfo().getLastActiveTime() >= 20000L) {
                    outDatedConnections.add(client.getMetaInfo().getConnectionId());
                    continue;
                }
                if (!client.getMetaInfo().pushQueueBlockTimesLastOver(300000L)) continue;
                outDatedConnections.add(client.getMetaInfo().getConnectionId());
            }
            Loggers.CONNECTION.info("Out dated connection ,size={}", (Object)outDatedConnections.size());
            if (CollectionUtils.isNotEmpty(outDatedConnections)) {
                final HashSet successConnections = new HashSet();
                final CountDownLatch latch = new CountDownLatch(outDatedConnections.size());
                for (final String outDateConnectionId : outDatedConnections) {
                    try {
                        final Connection connection = this.connectionManager.getConnection(outDateConnectionId);
                        if (connection != null) {
                            ClientDetectionRequest clientDetectionRequest = new ClientDetectionRequest();
                            connection.asyncRequest((Request)clientDetectionRequest, new RequestCallBack(){

                                public Executor getExecutor() {
                                    return null;
                                }

                                public long getTimeout() {
                                    return 5000L;
                                }

                                public void onResponse(Response response) {
                                    latch.countDown();
                                    if (response != null && response.isSuccess()) {
                                        connection.freshActiveTime();
                                        successConnections.add(outDateConnectionId);
                                    }
                                }

                                public void onException(Throwable e) {
                                    latch.countDown();
                                }
                            });
                            Loggers.CONNECTION.info("[{}]send connection active request ", (Object)outDateConnectionId);
                            continue;
                        }
                        latch.countDown();
                    }
                    catch (ConnectionAlreadyClosedException e) {
                        latch.countDown();
                    }
                    catch (Exception e) {
                        Loggers.CONNECTION.error("[{}]Error occurs when check client active detection ,error={}", (Object)outDateConnectionId, (Object)e);
                        latch.countDown();
                    }
                }
                latch.await(5000L, TimeUnit.MILLISECONDS);
                Loggers.CONNECTION.info("Out dated connection check successCount={}", (Object)successConnections.size());
                for (final String outDateConnectionId : outDatedConnections) {
                    if (successConnections.contains(outDateConnectionId)) continue;
                    Loggers.CONNECTION.info("[{}]Unregister Out dated connection....", (Object)outDateConnectionId);
                    this.connectionManager.unregister(outDateConnectionId);
                }
            }
            Loggers.CONNECTION.info("Connection check task end");
        }
        catch (Throwable e) {
            Loggers.CONNECTION.error("Error occurs during connection check... ", e);
        }
    }

    private void ejectOverLimitConnection() {
        if (this.getLoadClient() > 0) {
            try {
                Loggers.CONNECTION.info("Connection overLimit check task start, loadCount={}, redirectAddress={}", (Object)this.getLoadClient(), (Object)this.getRedirectAddress());
                int currentConnectionCount = this.connectionManager.getCurrentConnectionCount();
                int ejectingCount = currentConnectionCount - this.getLoadClient();
                if (ejectingCount > 0) {
                    HashSet<String> ids = new HashSet<String>(this.connectionManager.connections.keySet());
                    for (String id : ids) {
                        if (ejectingCount <= 0) break;
                        Connection connection = this.connectionManager.getConnection(id);
                        if (connection == null || !connection.getMetaInfo().isSdkSource() || !this.connectionManager.loadSingle(id, this.redirectAddress)) continue;
                        --ejectingCount;
                    }
                }
                Loggers.CONNECTION.info("Connection overLimit task end, current loadCount={}, has ejected loadCont={}", (Object)this.connectionManager.getCurrentConnectionCount(), (Object)(this.getLoadClient() - ejectingCount));
            }
            catch (Throwable e) {
                Loggers.CONNECTION.error("Error occurs during connection overLimit... ", e);
            }
            this.setRedirectAddress(null);
            this.setLoadClient(-1);
        }
    }

    @Override
    public String getName() {
        return "nacos";
    }
}

