/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.container.authenticator;

import com.tongweb.container.Authenticator;
import com.tongweb.container.Context;
import com.tongweb.container.Manager;
import com.tongweb.container.Session;
import com.tongweb.container.SessionEvent;
import com.tongweb.container.SessionListener;
import com.tongweb.container.authenticator.AuthenticatorBase;
import com.tongweb.container.authenticator.SingleSignOn;
import java.io.Serializable;

public class SingleSignOnListener
implements SessionListener,
Serializable {
    private static final long serialVersionUID = 1L;
    private final String ssoId;

    public SingleSignOnListener(String ssoId) {
        this.ssoId = ssoId;
    }

    @Override
    public void sessionEvent(SessionEvent event) {
        if (!"destroySession".equals(event.getType())) {
            return;
        }
        Session session = event.getSession();
        Manager manager = session.getManager();
        if (manager == null) {
            return;
        }
        Context context = manager.getContext();
        Authenticator authenticator = context.getAuthenticator();
        if (!(authenticator instanceof AuthenticatorBase)) {
            return;
        }
        SingleSignOn sso = ((AuthenticatorBase)authenticator).sso;
        if (sso == null) {
            return;
        }
        sso.sessionDestroyed(this.ssoId, session);
    }
}

