
专家库系统概要设计说明书
（一）引言
1．编写目的
本文档旨在为专家库系统的开发提供架构设计指导，明确系统模块划分、接口规范及关键技术方案，指导开发团队实现多租户专家库核心功能。目标读者包括项目经理、开发人员、测试工程师及运维团队。
2．项目背景
委托单位：某省级专家资源管理中心
开发单位：XX科技有限公司
主管部门：省级科技厅
系统关系：
作为统一用户中心的子系统
与OA系统、财务系统通过API网关对接
数据同步依赖消息队列
3．定义
术语
定义
多租户
支持不同行政区域独立使用系统资源（通过tenant_id字段实现）
专家互评
评审结束后专家间相互打分的流程（记录在zjk_evaluate表）
抽取规则
动态配置专家抽取算法（zjk_review_phase表存储规则）
Ruoyi-Cloud-Plus
基于Spring Cloud Alibaba的微服务框架
Seata
分布式事务解决方案
（二）任务概述
1．目标
构建支持专家全生命周期管理的系统平台，实现：
专家申请与资质审核
项目评审与专家抽取
绩效评估与积分统计
多维度数据分析报表
2．运行环境
类型
配置说明
硬件
Kubernetes集群（3 master + 6 worker）
软件
JDK17, SpringBoot 3.x, Kingbase 14
中间件
Redis 6.x, MinIO, Nacos 2.x, Seata 1.7
容器
Docker 20.10 + K8s 1.24
3．需求概述
功能域
核心需求
专家管理
信息录入（zjk_expert）、资质审核（status字段）、状态变更
项目管理
项目创建（zjk_product）、评审阶段配置（zjk_review_phase）
评审管理
自动抽取算法、请假管理（zjk_leave）、考勤记录
积分体系
信用规则（zjk_credit_rule）、积分计算（zjk_point_user）
统计分析
请假率分析（stsChart接口）、评审质量评估
4．条件与限制
通过三级等保认证
支持单租户10万级专家库
敏感数据加密存储（身份证号等）
关键操作审计日志保留10年
（三）总体设计
1．处理流程
graph TD
    登录 --> 专家申请 --> 资质审核 --> 专家库维护 --> 项目配置 --> 自动抽取 --> 评审执行 --> 专家互评 --> 积分计算 --> 统计分析
2．总体结构
graph LR
    网关层 --> 业务层 --> 数据层
    业务层 --> 专家服务(zjk-api)
    业务层 --> 评审服务(zjk-review)
    业务层 --> 积分服务(zjk-point)
    数据层 --> 缓存(Redis)
    数据层 --> 数据库(Kingbase)
    数据层 --> 文件存储(MinIO)

3．功能分配
模块
功能
对应服务
用户中心
统一认证、权限管理
ruoyi-auth
专家服务
专家信息管理、状态变更
zjk-api
评审服务
项目创建、专家抽取
zjk-review
积分服务
信用规则、积分计算
zjk-point
监控模块
系统健康监测、日志收集
ruoyi-monitor
（四）接口设计
1．外部接口
类型
协议/标准
示例
REST API
HTTP
POST /expert 新增专家
文件接口
MinIO SDK
MinioClient.putObject()
消息通知
RabbitMQ
评审结果异步通知
2．内部接口
接口类型
技术方案
示例
服务调用
OpenFeign
专家服务调用积分服务
数据同步
Canal监听
数据库变更同步到Redis
分布式事务
Seata
专家状态变更事务
关键接口示例：
// 请假统计接口
@GetMapping("/stsChart")
public R<StsLeaveVO> stsChart(Integer rangeMonth)

（五）数据结构设计
1．逻辑结构
erDiagram
    专家 ||--o{ 请假记录 : "1:N"
    专家 ||--o{ 评审记录 : "1:N"
    项目 ||--o{ 评审阶段 : "1:N"
    专家 }|--o{ 积分记录 : "1:N"

2．物理结构
表名
核心字段
说明
zjk_expert
status(0暂存/2正常/5退休)
专家主表
zjk_evaluate
item_id, expert_comment
评审记录
zjk_point_user
point_count, check_status
积分表
zjk_leave
start_date, leave_days
请假表
3．数据结构与程序关系
领域对象：ZjkExpert对应专家表
DTO对象：ExpertVO用于接口传输
缓存结构：专家基本信息缓存Redis Hash
（六）运行设计
1．运行模块组合
场景
模块组合
专家抽取
网关层 + 评审服务 + 专家服务
请假审批
网关层 + 专家服务 + 工作流引擎
2．运行控制
定时任务：通过@Scheduled实现
  @Scheduled(cron = "${annual-Inspection:0 0 1 12 * ?}")
  public void annualInspectionJob()

工作流：Activity驱动审批流程
3．运行时间
核心服务：7×24小时运行
批处理任务：凌晨1:00-3:00执行
（七）出错处理设计
1．出错输出信息
错误类型
输出格式
业务异常
{"code":50001, "msg":"专家角色校验失败"}
系统异常
{"code":500, "msg":"系统内部错误"}
2．出错处理对策
服务降级：Hystrix熔断机制
事务回滚：Seata保证数据一致性
日志追踪：ELK收集分析错误日志
（八）安全保密设计
1．数据安全
敏感字段加密：身份证号SM4加密存储
字段级权限：联系方式仅管理员可见（SaCheckRole控制）
传输安全：HTTPS + JWT令牌
2．操作审计
全链路日志追踪：MDC植入请求ID
关键操作记录：zjk_approval_process_logs表
（九）维护设计
1．热维护机制
配置热更新：Nacos动态调整参数
在线诊断：Arthas支持运行时问题排查
2．数据维护
备份类型
频率
保留策略
全量备份
每日
保留30天
Binlog
实时
保留7天

附件清单
系统架构图
核心实体ER图
接口规范文档
部署拓扑图
