package org.dromara.workflow.api.domain;

import java.util.List;
import java.util.Map;

/**
 * 通用 工作流服务
 *
 * @Author ZETA
 * @Date 2024/6/3
 */
public interface RemoteWorkflowService {


    /**
     * 启动任务
     * @param businessKey 业务 id
     * @param tableName  表名
     * @param variables 流程变量，前端会提交一个元素{'entity': {业务详情数据对象}}
     * @return 结果
     */
    Map<String, Object> startWorkFlow(String businessKey,String tableName,Map<String, Object> variables);


    /**
     * 根据业务 id 获取 taskId  以及processInstanceId
     * @param businessKey
     * @return
     */
    Map<String, Object> getTaskInfoByBusinessKey(String businessKey);

    /**
     * 获取可驳回的任务节点
     * @param processInstanceId
     * @return
     */
    String getNodeList(String processInstanceId);
    /**
     * 办理任务
     *
     * @param
     * @return 结果
     */
    boolean completeTask(String taskId, List<String> messageTypeList,Map<String, Object> variables,String businessId);


    /**
     * 撤销
     * @param businessKey
     * @return
     */
    boolean cancelProcessApply(String businessKey);


    /**
     * 驳回审批
     * @param taskId
     * @param messageTypeList
     * @param targetActivityId
     * @param message
     * @return
     */
    String backProcess(String taskId, List<String> messageTypeList,String targetActivityId,String message);


    /**
     * 运行中的实例 删除程实例，删除历史记录，删除业务与流程关联信息
     *
     * @param businessKeys 业务id
     * @return 结果
     */
    boolean deleteRunAndHisInstance(List<String> businessKeys);

    /**
     * 获取当前流程状态
     *
     * @param taskId 任务id
     */
    String getBusinessStatusByTaskId(String taskId);

    /**
     * 获取当前流程状态
     *
     * @param businessKey 业务id
     */
    String getBusinessStatus(String businessKey);

    /**
     * 设置流程变量(全局变量)
     *
     * @param taskId       任务id
     * @param variableName 变量名称
     * @param value        变量值
     */
    void setVariable(String taskId, String variableName, Object value);

    /**
     * 设置流程变量(全局变量)
     *
     * @param taskId    任务id
     * @param variables 流程变量
     */
    void setVariables(String taskId, Map<String, Object> variables);

    /**
     * 设置流程变量(本地变量,非全局变量)
     *
     * @param taskId       任务id
     * @param variableName 变量名称
     * @param value        变量值
     */
    void setVariableLocal(String taskId, String variableName, Object value);

    /**
     * 设置流程变量(本地变量,非全局变量)
     *
     * @param taskId    任务id
     * @param variables 流程变量
     */
    void setVariablesLocal(String taskId, Map<String, Object> variables);

    /**
     * 按照业务id查询流程实例id
     *
     * @param businessKey 业务id
     * @return 结果
     */
    String getInstanceIdByBusinessKey(String businessKey);


}
