package org.dromara.zjk.annualInspection.annualInspectionAudit.service;

import org.dromara.common.mybatis.core.page.PageQuery;
import org.dromara.common.mybatis.core.page.TableDataInfo;
import org.dromara.zjk.annualInspection.annualInspectionAudit.domain.bo.ZjkAnnualInspectionBo;
import org.dromara.zjk.annualInspection.annualInspectionAudit.domain.vo.ZjkAnnualInspectionVo;

import java.util.Collection;
import java.util.List;

/**
 * 年检管理Service接口
 *
 * @author zhangzhou
 * @date 2024-11-13
 */
public interface IZjkAnnualInspectionService {

    /**
     * 查询年检管理
     *
     * @param id 主键
     * @return 年检管理
     */
    ZjkAnnualInspectionVo queryById(Long id);

    /**
     * 分页查询年检管理列表
     *
     * @param bo        查询条件
     * @param pageQuery 分页参数
     * @return 年检管理分页列表
     */
    TableDataInfo<ZjkAnnualInspectionVo> queryPageList(ZjkAnnualInspectionBo bo, PageQuery pageQuery);

    /**
     * 查询符合条件的年检管理列表
     *
     * @param bo 查询条件
     * @return 年检管理列表
     */
    List<ZjkAnnualInspectionVo> queryList(ZjkAnnualInspectionBo bo);

    /**
     * 新增年检管理
     *
     * @param bo 年检管理
     * @return 是否新增成功
     */
    Boolean insertByBo(ZjkAnnualInspectionBo bo);

    /**
     * 修改年检管理
     *
     * @param bo 年检管理
     * @return 是否修改成功
     */
    Boolean updateByBo(ZjkAnnualInspectionBo bo);

    /**
     * 校验并批量删除年检管理信息
     *
     * @param ids     待删除的主键集合
     * @param isValid 是否进行有效性校验
     * @return 是否删除成功
     */
    Boolean deleteWithValidByIds(Collection<Long> ids, Boolean isValid);


    void batchAnnualInspection(ZjkAnnualInspectionBo zjkAnnualInspectionBo);


    /**
     * 定时任务自动年检
     */
    void executeAnnualInspection();
}
