package org.dromara.zjk.annualInspection.annualInspectionRecords.domain;

import org.dromara.common.tenant.core.TenantEntity;
import com.baomidou.mybatisplus.annotation.*;
import lombok.Data;
import lombok.EqualsAndHashCode;
import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.dromara.zjk.annotation.PropertyMsg;
import java.io.Serial;

/**
 * 年检记录对象 zjk_annual_inspection_records
 *
 * @author zhangzhou
 * @date 2024-11-13
 */
@Data
@EqualsAndHashCode(callSuper = true)
@TableName("zjk_annual_inspection_records")
public class ZjkAnnualInspectionRecords extends TenantEntity {

    @Serial
    private static final long serialVersionUID = 1L;

    /**
     * id
     */
    @PropertyMsg(propertyName = "id")
    private Long id;

    /**
     * 用户 id
     */
    @PropertyMsg(propertyName = "user_id")
    private Long userId;

    /**
     * 专家 id
     */
    @PropertyMsg(propertyName = "expert_id")
    private Long expertId;

    /**
     * 年检记录编号
     */
    @PropertyMsg(propertyName = "records_sn")
    private String recordsSn;

    /**
     * 年检审核编号
     */
    @PropertyMsg(propertyName = "annual_inspection_sn")
    private String annualInspectionSn;

    /**
     * 年检名称
     */
    @PropertyMsg(propertyName = "annual_inspection_name")
    private String annualInspectionName;

    /**
     * 审核方式(1 人工年检 2 自动年检)
     */
    @PropertyMsg(propertyName = "audit_type")
    private String auditType;

    /**
     * 年检状态(1 待年检 2 已通过 3 未通过)
     */
    @PropertyMsg(propertyName = "annual_inspection_status")
    private String annualInspectionStatus;

    /**
     * 审核时间
     */
    @PropertyMsg(propertyName = "audit_time")
    private Date auditTime;

    /**
     * 逻辑删除
     */
    @TableLogic
    @PropertyMsg(propertyName = "del_flag")
    private Long delFlag;


}
