package org.dromara.zjk.domain.bo;

import com.fasterxml.jackson.annotation.JsonFormat;
import org.dromara.zjk.domain.ZjkDataChangesLogs;
import org.dromara.common.mybatis.core.domain.BaseEntity;
import org.dromara.common.core.validate.AddGroup;
import org.dromara.common.core.validate.EditGroup;
import io.github.linpeilie.annotations.AutoMapper;
import lombok.Data;
import lombok.EqualsAndHashCode;
import jakarta.validation.constraints.*;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * 业务数据变更记录业务对象 zjk_data_changes_logs
 *
 * @author ygh
 * @date 2024-11-07
 */
@Data
@EqualsAndHashCode(callSuper = true)
@AutoMapper(target = ZjkDataChangesLogs.class, reverseConvertGenerate = false)
public class ZjkDataChangesLogsBo extends BaseEntity {

    /**
     * id
     */
    @NotNull(message = "id不能为空", groups = { AddGroup.class, EditGroup.class })
    private Long id;

    /**
     * 操作类型
     */
    @NotBlank(message = "操作类型不能为空", groups = { AddGroup.class, EditGroup.class })
    private String changeType;

    /**
     * 业务类型 1.专家信息变更 2.项目信息变更
     */
    @NotBlank(message = "业务类型 1.专家信息变更 2.项目信息变更不能为空", groups = { AddGroup.class, EditGroup.class })
    private String businessType;

    /**
     * 操作前数据
     */
    @NotBlank(message = "操作前数据不能为空", groups = { AddGroup.class, EditGroup.class })
    private String beforeOper;

    /**
     * 操作后数据
     */
    @NotBlank(message = "操作后数据不能为空", groups = { AddGroup.class, EditGroup.class })
    private String afterOper;

    /**
     * 操作 ip
     */
    @NotBlank(message = "操作 ip不能为空", groups = { AddGroup.class, EditGroup.class })
    private String operIp;


    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone="GMT+8")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date startTime;
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone="GMT+8")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date endTime;

}
