package org.dromara.zjk.domain.vo;

import com.alibaba.excel.annotation.ExcelIgnoreUnannotated;
import com.alibaba.excel.annotation.ExcelProperty;
import io.github.linpeilie.annotations.AutoMapper;
import lombok.Data;
import org.dromara.zjk.domain.ZjkExpertItem;
import org.dromara.zjk.domain.ZjkExpertMajor;
import org.dromara.zjk.domain.ZjkProduct;
import org.dromara.zjk.zwy.annotation.EncryptSensitive;

import java.io.Serial;
import java.io.Serializable;
import java.util.List;


/**
 * 专家项目对应视图对象 zjk_expert_item
 *
 * @author ygh
 * @date 2024-10-29
 */
@Data
@ExcelIgnoreUnannotated
@AutoMapper(target = ZjkExpertItem.class)
public class ZjkExpertItemVo implements Serializable {

    @Serial
    private static final long serialVersionUID = 1L;

    /**
     * 主键id
     */
    @ExcelProperty(value = "主键id")
    private Long id;

    /**
     * 专家id
     */
    @ExcelProperty(value = "专家id")
    private Long expertId;

    /**
     * 项目id
     */
    @ExcelProperty(value = "项目id")
    private Long itemId;

    //    专家请假状态（1：已请假；0：未请假）
    @ExcelProperty(value = "专家请假状态")
    private  String leaveStatus;

    //接受状态（1：已接受；0：未接受）
    @ExcelProperty(value = "接受状态")
    private String acceptStatus;

    /*
     * 专家列表
     * */
    private List<ZjkExpertVo> zjkExpertVo;

    /*
     * 项目信息
     * */
    private ZjkProductVo zjkProjectVo;

    /**
     * 规则id
     */
    @ExcelProperty(value = "规则id")
    private Long reviewId;


    private Long productCount;

    private Long userId;

    /**
     * 专家姓名
     */
    private String expertName;

    /**
     * 联系方式
     */
    @EncryptSensitive
    private String concat;

    /**
     * 工作单位
     */
    private String workUnit;

    /**
     * 职务
     */
    private String major;

    /**
     *  研究领域
     */
    private String performWorkName;

    /**
     * 数据来源
     */
    private Integer isSource;

    /**
     * 专家状态
     */
    private Integer extractionStatus;

    private String duty;

    private List<ZjkExpertMajor> zjkExpertMajorList;
    /**
     * 阶段
     */
    private String reviewSn;

    private Long itemExtreationId;
}
