package org.dromara.zjk.domain.vo;

import org.dromara.zjk.domain.ZjkLearningMaterials;
import com.alibaba.excel.annotation.ExcelIgnoreUnannotated;
import com.alibaba.excel.annotation.ExcelProperty;
import org.dromara.common.excel.annotation.ExcelDictFormat;
import org.dromara.common.excel.convert.ExcelDictConvert;
import io.github.linpeilie.annotations.AutoMapper;
import lombok.Data;

import java.io.Serial;
import java.io.Serializable;
import java.util.Date;



/**
 * 信用资料视图对象 zjk_learning_materials
 *
 * @author ygh
 * @date 2024-11-26
 */
@Data
@ExcelIgnoreUnannotated
@AutoMapper(target = ZjkLearningMaterials.class)
public class ZjkLearningMaterialsVo implements Serializable {

    @Serial
    private static final long serialVersionUID = 1L;

    /**
     * 主键
     */
    @ExcelProperty(value = "主键")
    private Long id;

    /**
     * 乐观锁
     */
    @ExcelProperty(value = "乐观锁")
    private Long revision;

    /**
     * 资料id
     */
    @ExcelProperty(value = "资料id")
    private String materialsId;

    /**
     * 资料名称
     */
    @ExcelProperty(value = "资料名称")
    private String materialsName;

    /**
     * 观看次数
     */
    @ExcelProperty(value = "观看次数")
    private String materialsCount;

    /**
     * 状态（0，失效，1.正常）
     */
    @ExcelProperty(value = "状态", converter = ExcelDictConvert.class)
    @ExcelDictFormat(readConverterExp = "0=，失效，1.正常")
    private String status;

    /**
     * 逻辑删除（1，失效，0.正常）
     */
    @ExcelProperty(value = "逻辑删除", converter = ExcelDictConvert.class)
    @ExcelDictFormat(readConverterExp = "1=，失效，0.正常")
    private String delFalg;

    /**
     * url地址
     * */
    private String materialsUrl;

    /**
     * 创建人
     * */
    private Long createBy;

    /**
     * 创建时间
     * */
    private Date createTime;

    /**
     * 创建人
     * */
    private String createName;


}
