package org.dromara.zjk.learning_world.service;

import org.dromara.common.mybatis.core.page.TableDataInfo;
import org.dromara.common.mybatis.core.page.PageQuery;
import org.dromara.zjk.learning_world.domain.bo.ZjkLearningCommontBo;
import org.dromara.zjk.learning_world.domain.vo.ZjkLearningCommontVo;

import java.util.Collection;
import java.util.List;

/**
 * 评论Service接口
 *
 * @author ygh
 * @date 2024-11-11
 */
public interface IZjkLearningCommontService {

    /**
     * 查询评论
     *
     * @param id 主键
     * @return 评论
     */
    ZjkLearningCommontVo queryById(Long id);

    /**
     * 分页查询评论列表
     *
     * @param bo        查询条件
     * @param pageQuery 分页参数
     * @return 评论分页列表
     */
    TableDataInfo<ZjkLearningCommontVo> queryPageList(ZjkLearningCommontBo bo, PageQuery pageQuery);

    /**
     * 查询符合条件的评论列表
     *
     * @param bo 查询条件
     * @return 评论列表
     */
    List<ZjkLearningCommontVo> queryList(ZjkLearningCommontBo bo);

    /**
     * 新增评论
     *
     * @param bo 评论
     * @return 是否新增成功
     */
    Boolean insertByBo(ZjkLearningCommontBo bo);

    /**
     * 修改评论
     *
     * @param bo 评论
     * @return 是否修改成功
     */
    Boolean updateByBo(ZjkLearningCommontBo bo);

    /**
     * 校验并批量删除评论信息
     *
     * @param ids     待删除的主键集合
     * @param isValid 是否进行有效性校验
     * @return 是否删除成功
     */
    Boolean deleteWithValidByIds(Collection<Long> ids, Boolean isValid);

    int updateStatuso(ZjkLearningCommontBo bo);
}
