package org.dromara.zjk.service.impl;

import cn.hutool.core.lang.UUID;
import org.dromara.common.core.constant.UserConstants;
import org.dromara.common.core.utils.MapstructUtils;
import org.dromara.common.core.utils.StringUtils;
import org.dromara.common.mybatis.core.page.TableDataInfo;
import org.dromara.common.mybatis.core.page.PageQuery;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import lombok.RequiredArgsConstructor;
import org.dromara.common.satoken.utils.LoginHelper;
import org.dromara.zjk.domain.ZjkLeaveRule;
import org.dromara.zjk.domain.bo.ZjkLeaveRuleBo;
import org.dromara.zjk.domain.vo.ZjkLeaveRuleVo;
import org.dromara.zjk.mapper.ZjkLeaveRuleMapper;
import org.dromara.zjk.service.IZjkLeaveRuleService;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;
import java.util.Collection;

/**
 * 【请填写功能名称】Service业务层处理
 *
 * @author ygh
 * @date 2024-10-30
 */
@RequiredArgsConstructor
@Service
public class ZjkLeaveRuleServiceImpl implements IZjkLeaveRuleService {

    private final ZjkLeaveRuleMapper baseMapper;

    /**
     * 查询【请填写功能名称】
     *
     * @param GID 主键
     * @return 【请填写功能名称】
     */
    @Override
    public ZjkLeaveRuleVo queryById(String GID){
        return baseMapper.selectVoById(GID);
    }

    /**
     * 分页查询【请填写功能名称】列表
     *
     * @param bo        查询条件
     * @param pageQuery 分页参数
     * @return 【请填写功能名称】分页列表
     */
    @Override
    public TableDataInfo<ZjkLeaveRuleVo> queryPageList(ZjkLeaveRuleBo bo, PageQuery pageQuery) {
        LambdaQueryWrapper<ZjkLeaveRule> lqw = buildQueryWrapper(bo);
        Page<ZjkLeaveRuleVo> result = baseMapper.selectVoPage(pageQuery.build(), lqw);
        return TableDataInfo.build(result);
    }

    /**
     * 查询符合条件的【请填写功能名称】列表
     *
     * @param bo 查询条件
     * @return 【请填写功能名称】列表
     */
    @Override
    public List<ZjkLeaveRuleVo> queryList(ZjkLeaveRuleBo bo) {
        LambdaQueryWrapper<ZjkLeaveRule> lqw = buildQueryWrapper(bo);
        return baseMapper.selectVoList(lqw);
    }

    private LambdaQueryWrapper<ZjkLeaveRule> buildQueryWrapper(ZjkLeaveRuleBo bo) {
        Map<String, Object> params = bo.getParams();
        LambdaQueryWrapper<ZjkLeaveRule> lqw = Wrappers.lambdaQuery();
        lqw.eq(StringUtils.isNotBlank(bo.getGID()), ZjkLeaveRule::getGid, bo.getGID());
        lqw.eq(bo.getLeaveDay() != null, ZjkLeaveRule::getLeaveDay, bo.getLeaveDay());
        lqw.eq(StringUtils.isNotBlank(bo.getBeforeDay()), ZjkLeaveRule::getBeforeDay, bo.getBeforeDay());
        lqw.eq(StringUtils.isNotBlank(bo.getProBeforeHour()), ZjkLeaveRule::getProBeforeHour, bo.getProBeforeHour());
        lqw.eq(bo.getCreateBy() != null, ZjkLeaveRule::getCreateBy, bo.getCreateBy());
        lqw.eq(bo.getCreateTime() != null, ZjkLeaveRule::getCreateTime, bo.getCreateTime());
        lqw.eq(bo.getUpdateBy() != null, ZjkLeaveRule::getUpdateBy, bo.getUpdateBy());
        lqw.eq(bo.getUpdateTime() != null, ZjkLeaveRule::getUpdateTime, bo.getUpdateTime());
        return lqw;
    }

    /**
     * 新增【请填写功能名称】
     *
     * @param bo 【请填写功能名称】
     * @return 是否新增成功
     */
    @Override
    public Boolean insertByBo(ZjkLeaveRuleBo bo) {
        ZjkLeaveRule add = MapstructUtils.convert(bo, ZjkLeaveRule.class);
        boolean flag = baseMapper.insert(add) > 0;
        if (flag) {
            bo.setGID(add.getGid());
        }
        return flag;
    }

    /**
     * 修改【请填写功能名称】
     *
     * @param bo 【请填写功能名称】
     * @return 是否修改成功
     */
    @Override
    public Boolean updateByBo(ZjkLeaveRuleBo bo) {
        ZjkLeaveRule update = MapstructUtils.convert(bo, ZjkLeaveRule.class);
        update.setGid(bo.getGID());
        return baseMapper.updateById(update) > 0;
    }

    /**
     * 校验并批量删除【请填写功能名称】信息
     *
     * @param ids     待删除的主键集合
     * @param isValid 是否进行有效性校验
     * @return 是否删除成功
     */
    @Override
    public Boolean deleteWithValidByIds(Collection<String> ids, Boolean isValid) {
        if(isValid){
            //TODO 做一些业务上的校验,判断是否需要校验
        }
        return baseMapper.deleteByIds(ids) > 0;
    }

    @Override
    public ZjkLeaveRuleVo selectRuleByTannet() {
        ZjkLeaveRuleVo zjkLeaveRuleVo = baseMapper.selectRuleByTannet(LoginHelper.getTenantId());
        if(zjkLeaveRuleVo==null){
            ZjkLeaveRuleVo vo = new ZjkLeaveRuleVo();
            //为空时默认复制
            String gid = UUID.randomUUID().toString();
            vo.setGID(gid);
            vo.setLeaveDay(UserConstants.LEAVE_DAY);
            vo.setProBeforeHour(UserConstants.LEAVE_BEFORE_PRO);
            vo.setBeforeDay(UserConstants.LEAVE_BEFORE_DAY);
            ZjkLeaveRule add = MapstructUtils.convert(vo, ZjkLeaveRule.class);
            baseMapper.insert(add);
            zjkLeaveRuleVo = vo;
        }
        return  zjkLeaveRuleVo;
    }
}
