/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.core.persistence;

import com.alibaba.nacos.api.exception.runtime.NacosRuntimeException;
import com.alibaba.nacos.common.JustForTest;
import com.alibaba.nacos.common.model.RestResult;
import com.alibaba.nacos.common.model.RestResultUtils;
import com.alibaba.nacos.common.notify.Event;
import com.alibaba.nacos.common.notify.NotifyCenter;
import com.alibaba.nacos.common.notify.listener.Subscriber;
import com.alibaba.nacos.common.utils.ExceptionUtil;
import com.alibaba.nacos.common.utils.LoggerUtils;
import com.alibaba.nacos.common.utils.MD5Utils;
import com.alibaba.nacos.common.utils.Preconditions;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.consistency.SerializeFactory;
import com.alibaba.nacos.consistency.Serializer;
import com.alibaba.nacos.consistency.cp.CPProtocol;
import com.alibaba.nacos.consistency.cp.RequestProcessor4CP;
import com.alibaba.nacos.consistency.entity.ReadRequest;
import com.alibaba.nacos.consistency.entity.Response;
import com.alibaba.nacos.consistency.entity.WriteRequest;
import com.alibaba.nacos.consistency.exception.ConsistencyException;
import com.alibaba.nacos.consistency.snapshot.SnapshotOperation;
import com.alibaba.nacos.core.cluster.ServerMemberManager;
import com.alibaba.nacos.core.distributed.ProtocolManager;
import com.alibaba.nacos.core.persistence.DerbySnapshotOperation;
import com.alibaba.nacos.core.utils.ClassUtils;
import com.alibaba.nacos.persistence.configuration.condition.ConditionDistributedEmbedStorage;
import com.alibaba.nacos.persistence.datasource.DynamicDataSource;
import com.alibaba.nacos.persistence.datasource.LocalDataSourceServiceImpl;
import com.alibaba.nacos.persistence.exception.NJdbcException;
import com.alibaba.nacos.persistence.model.event.DerbyLoadEvent;
import com.alibaba.nacos.persistence.model.event.RaftDbErrorEvent;
import com.alibaba.nacos.persistence.repository.RowMapperManager;
import com.alibaba.nacos.persistence.repository.embedded.EmbeddedStorageContextHolder;
import com.alibaba.nacos.persistence.repository.embedded.hook.EmbeddedApplyHook;
import com.alibaba.nacos.persistence.repository.embedded.hook.EmbeddedApplyHookHolder;
import com.alibaba.nacos.persistence.repository.embedded.operate.BaseDatabaseOperate;
import com.alibaba.nacos.persistence.repository.embedded.sql.ModifyRequest;
import com.alibaba.nacos.persistence.repository.embedded.sql.SelectRequest;
import com.alibaba.nacos.persistence.utils.PersistenceExecutor;
import com.alibaba.nacos.sys.utils.DiskUtils;
import com.google.protobuf.ByteString;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Conditional;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.jdbc.BadSqlGrammarException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Component;
import org.springframework.transaction.support.TransactionTemplate;

@Conditional(value={ConditionDistributedEmbedStorage.class})
@Component
public class DistributedDatabaseOperateImpl
extends RequestProcessor4CP
implements BaseDatabaseOperate {
    private static final Logger LOGGER = LoggerFactory.getLogger(DistributedDatabaseOperateImpl.class);
    private static final String DATA_IMPORT_KEY = "00--0-data_import-0--00";
    private final ServerMemberManager memberManager;
    private CPProtocol protocol;
    private LocalDataSourceServiceImpl dataSourceService;
    private JdbcTemplate jdbcTemplate;
    private TransactionTemplate transactionTemplate;
    private final Serializer serializer = SerializeFactory.getDefault();
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock.ReadLock readLock = this.lock.readLock();
    private final ReentrantReadWriteLock.WriteLock writeLock = this.lock.writeLock();

    public DistributedDatabaseOperateImpl(ServerMemberManager memberManager, ProtocolManager protocolManager) throws Exception {
        this.memberManager = memberManager;
        this.protocol = protocolManager.getCpProtocol();
        this.init();
    }

    protected void init() throws Exception {
        this.dataSourceService = (LocalDataSourceServiceImpl)DynamicDataSource.getInstance().getDataSource();
        this.dataSourceService.cleanAndReopenDerby();
        this.jdbcTemplate = this.dataSourceService.getJdbcTemplate();
        this.transactionTemplate = this.dataSourceService.getTransactionTemplate();
        NotifyCenter.registerToSharePublisher(RaftDbErrorEvent.class);
        NotifyCenter.registerToSharePublisher(DerbyLoadEvent.class);
        NotifyCenter.registerSubscriber((Subscriber)new Subscriber<RaftDbErrorEvent>(){

            public void onEvent(RaftDbErrorEvent event) {
                DistributedDatabaseOperateImpl.this.dataSourceService.setHealthStatus("DOWN");
            }

            public Class<? extends Event> subscribeType() {
                return RaftDbErrorEvent.class;
            }
        });
        this.protocol.addRequestProcessors(Collections.singletonList(this));
        LOGGER.info("use DistributedTransactionServicesImpl");
    }

    @JustForTest
    public void mockConsistencyProtocol(CPProtocol protocol) {
        this.protocol = protocol;
    }

    public <R> R queryOne(String sql, Class<R> cls) {
        try {
            LoggerUtils.printIfDebugEnabled((Logger)LOGGER, (String)"queryOne info : sql : {}", (Object[])new Object[]{sql});
            byte[] data = this.serializer.serialize((Object)SelectRequest.builder().queryType((byte)1).sql(sql).className(cls.getCanonicalName()).build());
            boolean blockRead = EmbeddedStorageContextHolder.containsExtendInfo((String)"00--0-read-join-0--00");
            Response response = this.innerRead(ReadRequest.newBuilder().setGroup(this.group()).setData(ByteString.copyFrom((byte[])data)).build(), blockRead);
            if (response.getSuccess()) {
                return (R)this.serializer.deserialize(response.getData().toByteArray(), cls);
            }
            throw new NJdbcException(response.getErrMsg(), response.getErrMsg());
        }
        catch (Exception e) {
            LOGGER.error("An exception occurred during the query operation : {}", (Object)e.toString());
            throw new NacosRuntimeException(500, e.toString());
        }
    }

    public <R> R queryOne(String sql, Object[] args, Class<R> cls) {
        try {
            LoggerUtils.printIfDebugEnabled((Logger)LOGGER, (String)"queryOne info : sql : {}, args : {}", (Object[])new Object[]{sql, args});
            byte[] data = this.serializer.serialize((Object)SelectRequest.builder().queryType((byte)2).sql(sql).args(args).className(cls.getCanonicalName()).build());
            boolean blockRead = EmbeddedStorageContextHolder.containsExtendInfo((String)"00--0-read-join-0--00");
            Response response = this.innerRead(ReadRequest.newBuilder().setGroup(this.group()).setData(ByteString.copyFrom((byte[])data)).build(), blockRead);
            if (response.getSuccess()) {
                return (R)this.serializer.deserialize(response.getData().toByteArray(), cls);
            }
            throw new NJdbcException(response.getErrMsg(), response.getErrMsg());
        }
        catch (Exception e) {
            LOGGER.error("An exception occurred during the query operation : {}", (Object)e.toString());
            throw new NacosRuntimeException(500, e.toString());
        }
    }

    public <R> R queryOne(String sql, Object[] args, RowMapper<R> mapper) {
        try {
            LoggerUtils.printIfDebugEnabled((Logger)LOGGER, (String)"queryOne info : sql : {}, args : {}", (Object[])new Object[]{sql, args});
            byte[] data = this.serializer.serialize((Object)SelectRequest.builder().queryType((byte)0).sql(sql).args(args).className(mapper.getClass().getCanonicalName()).build());
            boolean blockRead = EmbeddedStorageContextHolder.containsExtendInfo((String)"00--0-read-join-0--00");
            Response response = this.innerRead(ReadRequest.newBuilder().setGroup(this.group()).setData(ByteString.copyFrom((byte[])data)).build(), blockRead);
            if (response.getSuccess()) {
                return (R)this.serializer.deserialize(response.getData().toByteArray(), ClassUtils.resolveGenericTypeByInterface(mapper.getClass()));
            }
            throw new NJdbcException(response.getErrMsg(), response.getErrMsg());
        }
        catch (Exception e) {
            LOGGER.error("An exception occurred during the query operation : {}", (Object)e.toString());
            throw new NacosRuntimeException(500, e.toString());
        }
    }

    public <R> List<R> queryMany(String sql, Object[] args, RowMapper<R> mapper) {
        try {
            LoggerUtils.printIfDebugEnabled((Logger)LOGGER, (String)"queryMany info : sql : {}, args : {}", (Object[])new Object[]{sql, args});
            byte[] data = this.serializer.serialize((Object)SelectRequest.builder().queryType((byte)3).sql(sql).args(args).className(mapper.getClass().getCanonicalName()).build());
            boolean blockRead = EmbeddedStorageContextHolder.containsExtendInfo((String)"00--0-read-join-0--00");
            Response response = this.innerRead(ReadRequest.newBuilder().setGroup(this.group()).setData(ByteString.copyFrom((byte[])data)).build(), blockRead);
            if (response.getSuccess()) {
                return (List)this.serializer.deserialize(response.getData().toByteArray(), List.class);
            }
            throw new NJdbcException(response.getErrMsg());
        }
        catch (Exception e) {
            LOGGER.error("An exception occurred during the query operation : {}", (Object)e.toString());
            throw new NacosRuntimeException(500, e.toString());
        }
    }

    public <R> List<R> queryMany(String sql, Object[] args, Class<R> rClass) {
        try {
            LoggerUtils.printIfDebugEnabled((Logger)LOGGER, (String)"queryMany info : sql : {}, args : {}", (Object[])new Object[]{sql, args});
            byte[] data = this.serializer.serialize((Object)SelectRequest.builder().queryType((byte)5).sql(sql).args(args).className(rClass.getCanonicalName()).build());
            boolean blockRead = EmbeddedStorageContextHolder.containsExtendInfo((String)"00--0-read-join-0--00");
            Response response = this.innerRead(ReadRequest.newBuilder().setGroup(this.group()).setData(ByteString.copyFrom((byte[])data)).build(), blockRead);
            if (response.getSuccess()) {
                return (List)this.serializer.deserialize(response.getData().toByteArray(), List.class);
            }
            throw new NJdbcException(response.getErrMsg());
        }
        catch (Exception e) {
            LOGGER.error("An exception occurred during the query operation : {}", (Object)e.toString());
            throw new NacosRuntimeException(500, e.toString());
        }
    }

    public List<Map<String, Object>> queryMany(String sql, Object[] args) {
        try {
            LoggerUtils.printIfDebugEnabled((Logger)LOGGER, (String)"queryMany info : sql : {}, args : {}", (Object[])new Object[]{sql, args});
            byte[] data = this.serializer.serialize((Object)SelectRequest.builder().queryType((byte)4).sql(sql).args(args).build());
            boolean blockRead = EmbeddedStorageContextHolder.containsExtendInfo((String)"00--0-read-join-0--00");
            Response response = this.innerRead(ReadRequest.newBuilder().setGroup(this.group()).setData(ByteString.copyFrom((byte[])data)).build(), blockRead);
            if (response.getSuccess()) {
                return (List)this.serializer.deserialize(response.getData().toByteArray(), List.class);
            }
            throw new NJdbcException(response.getErrMsg());
        }
        catch (Exception e) {
            LOGGER.error("An exception occurred during the query operation : {}", (Object)e.toString());
            throw new NacosRuntimeException(500, e.toString());
        }
    }

    private Response innerRead(ReadRequest request, boolean blockRead) throws Exception {
        if (blockRead) {
            return (Response)this.protocol.aGetData(request).join();
        }
        return this.protocol.getData(request);
    }

    public CompletableFuture<RestResult<String>> dataImport(File file) {
        return CompletableFuture.supplyAsync(() -> {
            try (DiskUtils.LineIterator iterator = DiskUtils.lineIterator((File)file);){
                int batchSize = 1000;
                ArrayList<String> batchUpdate = new ArrayList<String>(batchSize);
                ArrayList<CompletableFuture> futures = new ArrayList<CompletableFuture>();
                while (iterator.hasNext()) {
                    boolean submit;
                    String sql = iterator.next();
                    if (StringUtils.isNotBlank((String)sql)) {
                        batchUpdate.add(sql);
                    }
                    if (!(submit = batchUpdate.size() == batchSize || !iterator.hasNext())) continue;
                    List requests = batchUpdate.stream().map(ModifyRequest::new).collect(Collectors.toList());
                    CompletableFuture future = this.protocol.writeAsync(WriteRequest.newBuilder().setGroup(this.group()).setData(ByteString.copyFrom((byte[])this.serializer.serialize(requests))).putExtendInfo(DATA_IMPORT_KEY, Boolean.TRUE.toString()).build());
                    futures.add(future);
                    batchUpdate.clear();
                }
                CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).join();
                for (CompletableFuture future : futures) {
                    Response response = (Response)future.get();
                    if (response.getSuccess()) continue;
                    RestResult restResult = RestResultUtils.failed((String)response.getErrMsg());
                    return restResult;
                }
                RestResult restResult = RestResultUtils.success();
                return restResult;
            }
            catch (Throwable ex) {
                LOGGER.error("data import has error :", ex);
                return RestResultUtils.failed((String)ex.getMessage());
            }
        });
    }

    public Boolean update(List<ModifyRequest> sqlContext, BiConsumer<Boolean, Throwable> consumer) {
        try {
            LoggerUtils.printIfDebugEnabled((Logger)LOGGER, (String)"modifyRequests info : {}", (Object[])new Object[]{sqlContext});
            String key = System.currentTimeMillis() + "-" + this.group() + "-" + this.memberManager.getSelf().getAddress() + "-" + MD5Utils.md5Hex((String)sqlContext.toString(), (String)"UTF-8");
            WriteRequest request = WriteRequest.newBuilder().setGroup(this.group()).setKey(key).setData(ByteString.copyFrom((byte[])this.serializer.serialize(sqlContext))).putAllExtendInfo(EmbeddedStorageContextHolder.getCurrentExtendInfo()).setType(sqlContext.getClass().getCanonicalName()).build();
            if (Objects.isNull(consumer)) {
                Response response2 = this.protocol.write(request);
                if (response2.getSuccess()) {
                    return true;
                }
                LOGGER.error("execute sql modify operation failed : {}", (Object)response2.getErrMsg());
                return false;
            }
            this.protocol.writeAsync(request).whenComplete((response, ex) -> {
                String errMsg = Objects.isNull(ex) ? response.getErrMsg() : ExceptionUtil.getCause((Throwable)ex).getMessage();
                consumer.accept(response.getSuccess(), (Throwable)(StringUtils.isBlank((CharSequence)errMsg) ? null : new NJdbcException(errMsg)));
            });
            return true;
        }
        catch (TimeoutException e) {
            LOGGER.error("An timeout exception occurred during the update operation");
            throw new NacosRuntimeException(500, e.toString());
        }
        catch (Throwable e) {
            LOGGER.error("An exception occurred during the update operation : {}", e);
            throw new NacosRuntimeException(500, e.toString());
        }
    }

    public List<SnapshotOperation> loadSnapshotOperate() {
        return Collections.singletonList(new DerbySnapshotOperation(this.writeLock));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response onRequest(ReadRequest request) {
        SelectRequest selectRequest = null;
        this.readLock.lock();
        try {
            Object data;
            selectRequest = (SelectRequest)this.serializer.deserialize(request.getData().toByteArray(), SelectRequest.class);
            LoggerUtils.printIfDebugEnabled((Logger)LOGGER, (String)"getData info : selectRequest : {}", (Object[])new Object[]{selectRequest});
            RowMapper mapper = RowMapperManager.getRowMapper((String)selectRequest.getClassName());
            byte type = selectRequest.getQueryType();
            switch (type) {
                case 0: {
                    data = this.queryOne(this.jdbcTemplate, selectRequest.getSql(), selectRequest.getArgs(), mapper);
                    break;
                }
                case 1: {
                    data = this.queryOne(this.jdbcTemplate, selectRequest.getSql(), ClassUtils.findClassByName(selectRequest.getClassName()));
                    break;
                }
                case 2: {
                    data = this.queryOne(this.jdbcTemplate, selectRequest.getSql(), selectRequest.getArgs(), ClassUtils.findClassByName(selectRequest.getClassName()));
                    break;
                }
                case 3: {
                    data = this.queryMany(this.jdbcTemplate, selectRequest.getSql(), selectRequest.getArgs(), mapper);
                    break;
                }
                case 4: {
                    data = this.queryMany(this.jdbcTemplate, selectRequest.getSql(), selectRequest.getArgs());
                    break;
                }
                case 5: {
                    data = this.queryMany(this.jdbcTemplate, selectRequest.getSql(), selectRequest.getArgs(), ClassUtils.findClassByName(selectRequest.getClassName()));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported data query categories");
                }
            }
            ByteString bytes = data == null ? ByteString.EMPTY : ByteString.copyFrom((byte[])this.serializer.serialize(data));
            Response response = Response.newBuilder().setSuccess(true).setData(bytes).build();
            return response;
        }
        catch (Exception e) {
            LOGGER.error("There was an error querying the data, request : {}, error : {}", (Object)selectRequest, (Object)e.toString());
            Response response = Response.newBuilder().setSuccess(false).setErrMsg(ClassUtils.getSimplaName(e) + ":" + ExceptionUtil.getCause((Throwable)e).getMessage()).build();
            return response;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response onApply(WriteRequest log) {
        LoggerUtils.printIfDebugEnabled((Logger)LOGGER, (String)"onApply info : log : {}", (Object[])new Object[]{log});
        ByteString byteString = log.getData();
        Preconditions.checkArgument((byteString != null ? 1 : 0) != 0, (Object)"Log.getData() must not null");
        ReentrantReadWriteLock.ReadLock lock = this.readLock;
        lock.lock();
        try {
            List sqlContext = (List)this.serializer.deserialize(byteString.toByteArray(), List.class);
            boolean isOk = false;
            if (log.containsExtendInfo(DATA_IMPORT_KEY)) {
                isOk = this.doDataImport(this.jdbcTemplate, sqlContext);
            } else {
                sqlContext.sort(Comparator.comparingInt(ModifyRequest::getExecuteNo));
                isOk = this.update(this.transactionTemplate, this.jdbcTemplate, sqlContext);
                PersistenceExecutor.executeEmbeddedDump(() -> {
                    for (EmbeddedApplyHook each : EmbeddedApplyHookHolder.getInstance().getAllHooks()) {
                        each.afterApply(log);
                    }
                });
            }
            Response response = Response.newBuilder().setSuccess(isOk).build();
            return response;
        }
        catch (DataIntegrityViolationException | BadSqlGrammarException e) {
            Response response = Response.newBuilder().setSuccess(false).setErrMsg(e.toString()).build();
            return response;
        }
        catch (DataAccessException e) {
            throw new ConsistencyException(e.toString());
        }
        catch (Exception e) {
            LoggerUtils.printIfWarnEnabled((Logger)LOGGER, (String)"onApply warn : log : {}", (Object[])new Object[]{log, e});
            Response response = Response.newBuilder().setSuccess(false).setErrMsg(e.toString()).build();
            return response;
        }
        finally {
            lock.unlock();
        }
    }

    public void onError(Throwable throwable) {
        NotifyCenter.publishEvent((Event)new RaftDbErrorEvent(throwable));
    }

    public String group() {
        return "nacos_config";
    }
}

