/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.core.remote;

import com.alibaba.nacos.common.remote.ConnectionType;
import com.alibaba.nacos.common.remote.PayloadRegistry;
import com.alibaba.nacos.core.remote.tls.RpcServerSslContextRefresherHolder;
import com.alibaba.nacos.core.utils.Loggers;
import com.alibaba.nacos.sys.env.EnvUtil;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;

public abstract class BaseRpcServer {
    @PostConstruct
    public void start() throws Exception {
        String serverName = this.getClass().getSimpleName();
        Loggers.REMOTE.info("Nacos {} Rpc server starting at port {}", (Object)serverName, (Object)this.getServicePort());
        this.startServer();
        if (RpcServerSslContextRefresherHolder.getInstance() != null) {
            RpcServerSslContextRefresherHolder.getInstance().refresh(this);
        }
        Loggers.REMOTE.info("Nacos {} Rpc server started at port {}", (Object)serverName, (Object)this.getServicePort());
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            Loggers.REMOTE.info("Nacos {} Rpc server stopping", (Object)serverName);
            try {
                this.stopServer();
                Loggers.REMOTE.info("Nacos {} Rpc server stopped successfully...", (Object)serverName);
            }
            catch (Exception e) {
                Loggers.REMOTE.error("Nacos {} Rpc server stopped fail...", (Object)serverName, (Object)e);
            }
        }));
    }

    public abstract ConnectionType getConnectionType();

    public abstract void reloadProtocolContext();

    public abstract void startServer() throws Exception;

    public abstract int rpcPortOffset();

    public int getServicePort() {
        return EnvUtil.getPort() + this.rpcPortOffset();
    }

    public final void stopServer() throws Exception {
        this.shutdownServer();
    }

    @PreDestroy
    public abstract void shutdownServer();

    static {
        PayloadRegistry.init();
    }
}

