/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.healthcheck.heartbeat;

import com.alibaba.nacos.common.spi.NacosServiceLoader;
import com.alibaba.nacos.naming.core.v2.client.impl.IpPortBasedClient;
import com.alibaba.nacos.naming.core.v2.pojo.HealthCheckInstancePublishInfo;
import com.alibaba.nacos.naming.core.v2.pojo.Service;
import com.alibaba.nacos.naming.healthcheck.heartbeat.ExpiredInstanceChecker;
import com.alibaba.nacos.naming.healthcheck.heartbeat.InstanceBeatChecker;
import com.alibaba.nacos.naming.healthcheck.heartbeat.UnhealthyInstanceChecker;
import com.alibaba.nacos.naming.interceptor.Interceptable;
import java.util.LinkedList;
import java.util.List;

public class InstanceBeatCheckTask
implements Interceptable {
    private static final List<InstanceBeatChecker> CHECKERS = new LinkedList<InstanceBeatChecker>();
    private final IpPortBasedClient client;
    private final Service service;
    private final HealthCheckInstancePublishInfo instancePublishInfo;

    public InstanceBeatCheckTask(IpPortBasedClient client, Service service, HealthCheckInstancePublishInfo instancePublishInfo) {
        this.client = client;
        this.service = service;
        this.instancePublishInfo = instancePublishInfo;
    }

    @Override
    public void passIntercept() {
        for (InstanceBeatChecker each : CHECKERS) {
            each.doCheck(this.client, this.service, this.instancePublishInfo);
        }
    }

    @Override
    public void afterIntercept() {
    }

    public IpPortBasedClient getClient() {
        return this.client;
    }

    public Service getService() {
        return this.service;
    }

    public HealthCheckInstancePublishInfo getInstancePublishInfo() {
        return this.instancePublishInfo;
    }

    static {
        CHECKERS.add(new UnhealthyInstanceChecker());
        CHECKERS.add(new ExpiredInstanceChecker());
        CHECKERS.addAll(NacosServiceLoader.load(InstanceBeatChecker.class));
    }
}

