# 专家库索引设计表格


| 索引名称                   | 表名       | 字段        | 索引类型    | 描述                                       |
| -------------------------- | ---------- | ----------- | ----------- | ------------------------------------------ |
| idx_zjk_expert_create_time | zjk_expert | create_time | B-tree      | 用于按创建时间快速查询专家信息             |
| idx_zjk_expert_update_time | zjk_expert | update_time | B-tree      | 用于按更新时间快速查询专家信息             |
| idx_zjk_expert_status      | zjk_expert | status      | B-tree      | 用于按状态筛选专家（如正常、离职、退休等） |
| idx_zjk_expert_expert_id   | zjk_expert | expert_id   | Primary Key | 主键索引，唯一标识专家记录                 |
| idx_zjk_expert_user_id     | zjk_expert | user_id     | B-tree      | 外键索引，关联登录用户ID                   |
| idx_zjk_expert_name        | zjk_expert | expert_name | B-tree      | 用于按专家姓名进行模糊搜索或排序           |
| idx_zjk_expert_id_card     | zjk_expert | id_card     | Unique      | 唯一性索引，确保身份证号唯一               |
| idx_zjk_expert_email       | zjk_expert | email       | Unique      | 唯一性索引，确保邮箱唯一                   |

## zjk_expert_money_info 表索引


| 索引名称                           | 表名                  | 字段            | 索引类型    | 描述                                     |
| ---------------------------------- | --------------------- | --------------- | ----------- | ---------------------------------------- |
| idx_zjk_money_info_expert_id       | zjk_expert_money_info | expert_id       | B-tree      | 外键索引，关联专家表zjk_expert.expert_id |
| idx_zjk_money_info_product_id      | zjk_expert_money_info | product_id      | B-tree      | 用于按项目ID查询费用信息                 |
| idx_zjk_money_info_settlement_date | zjk_expert_money_info | settlement_date | B-tree      | 用于按结算日期筛选记录                   |
| idx_zjk_money_info_status          | zjk_expert_money_info | status          | B-tree      | 用于按结算状态筛选（0未结束，1已结算）   |
| idx_zjk_money_info_money_id        | zjk_expert_money_info | money_id        | Primary Key | 主键索引，唯一标识费用记录               |

## zjk_expert_item 表索引


| 索引名称                             | 表名            | 字段              | 索引类型    | 描述                                       |
| ------------------------------------ | --------------- | ----------------- | ----------- | ------------------------------------------ |
| idx_zjk_expert_item_expert_id        | zjk_expert_item | expert_id         | B-tree      | 外键索引，关联专家表zjk_expert.expert_id   |
| idx_zjk_expert_item_item_id          | zjk_expert_item | item_id           | B-tree      | 外键索引，关联项目ID                       |
| idx_zjk_expert_item_accept_status    | zjk_expert_item | accept_status     | B-tree      | 用于筛选接受状态（已接受、未接受、拒绝等） |
| idx_zjk_expert_item_extration_status | zjk_expert_item | extraction_status | B-tree      | 用于筛选抽取状态（取消、确认、重抽）       |
| idx_zjk_expert_item_id               | zjk_expert_item | id                | Primary Key | 主键索引，唯一标识抽取记录                 |

## zjk_evaluate 表索引


| 索引名称                     | 表名         | 字段        | 索引类型    | 描述                                       |
| ---------------------------- | ------------ | ----------- | ----------- | ------------------------------------------ |
| idx_zjk_evaluate_expert_id   | zjk_evaluate | expert_id   | B-tree      | 外键索引，关联专家ID                       |
| idx_zjk_evaluate_item_id     | zjk_evaluate | item_id     | B-tree      | 外键索引，关联评审项目ID                   |
| idx_zjk_evaluate_status      | zjk_evaluate | status      | B-tree      | 用于筛选评价状态（已评价、未评价）         |
| idx_zjk_evaluate_source_role | zjk_evaluate | source_role | B-tree      | 用于筛选评价角色（专家互评、管理员评价等） |
| idx_zjk_evaluate_id          | zjk_evaluate | id          | Primary Key | 主键索引，唯一标识评价记录                 |

## zjk_invoice 表索引


| 索引名称                       | 表名        | 字段           | 索引类型    | 描述                         |
| ------------------------------ | ----------- | -------------- | ----------- | ---------------------------- |
| idx_zjk_invoice_expert_id      | zjk_invoice | expert_id      | B-tree      | 外键索引，关联专家ID         |
| idx_zjk_invoice_invoice_number | zjk_invoice | invoice_number | Unique      | 唯一性索引，确保发票号码唯一 |
| idx_zjk_invoice_start_date     | zjk_invoice | start_date     | B-tree      | 用于按开票日期筛选发票记录   |
| idx_zjk_invoice_id             | zjk_invoice | id             | Primary Key | 主键索引，唯一标识发票记录   |

## zjk_point 表索引


| 索引名称                | 表名      | 字段      | 索引类型    | 描述                       |
| ----------------------- | --------- | --------- | ----------- | -------------------------- |
| idx_zjk_point_expert_id | zjk_point | expert_id | B-tree      | 外键索引，关联专家ID       |
| idx_zjk_point_rule_id   | zjk_point | rule_id   | B-tree      | 关联积分规则ID             |
| idx_zjk_point_points    | zjk_point | points    | B-tree      | 用于按积分值排序或筛选     |
| idx_zjk_point_id        | zjk_point | ID        | Primary Key | 主键索引，唯一标识积分记录 |

## zjk_annual_inspection 表索引


| 索引名称                             | 表名                  | 字段                     | 索引类型    | 描述                                     |
| ------------------------------------ | --------------------- | ------------------------ | ----------- | ---------------------------------------- |
| idx_zjk_annual_inspection_expert_id  | zjk_annual_inspection | expert_id                | B-tree      | 外键索引，关联专家ID                     |
| idx_zjk_annual_inspection_status     | zjk_annual_inspection | annual_inspection_status | B-tree      | 用于筛选年检状态（待年检、通过、未通过） |
| idx_zjk_annual_inspection_audit_time | zjk_annual_inspection | audit_time               | B-tree      | 用于按审核时间筛选记录                   |
| idx_zjk_annual_inspection_id         | zjk_annual_inspection | id                       | Primary Key | 主键索引，唯一标识年检记录               |

## zjk_credit_reward 表索引


| 索引名称                              | 表名              | 字段            | 索引类型    | 描述                           |
| ------------------------------------- | ----------------- | --------------- | ----------- | ------------------------------ |
| idx_zjk_credit_reward_effect_standard | zjk_credit_reward | effect_standard | B-tree      | 用于按生效标准筛选信用奖励规则 |
| idx_zjk_credit_reward_is_forever      | zjk_credit_reward | is_forever      | B-tree      | 用于筛选是否永久生效的信用奖励 |
| idx_zjk_credit_reward_id              | zjk_credit_reward | ID              | Primary Key | 主键索引，唯一标识信用奖励记录 |

## zjk_money_statement 表索引


| 索引名称                                 | 表名                | 字段             | 索引类型    | 描述                           |
| ---------------------------------------- | ------------------- | ---------------- | ----------- | ------------------------------ |
| idx_zjk_money_statement_type             | zjk_money_statement | type             | B-tree      | 用于筛选报表类型（年报、月报） |
| idx_zjk_money_statement_period           | zjk_money_statement | period           | B-tree      | 用于筛选周期（每年、每月）     |
| idx_zjk_money_statement_scope_start_time | zjk_money_statement | scope_start_time | B-tree      | 用于按时间范围筛选费用报表     |
| idx_zjk_money_statement_id               | zjk_money_statement | id               | Primary Key | 主键索引，唯一标识报表记录     |

## zjk_point_reward 表索引


| 索引名称                             | 表名             | 字段            | 索引类型    | 描述                           |
| ------------------------------------ | ---------------- | --------------- | ----------- | ------------------------------ |
| idx_zjk_point_reward_effect_standard | zjk_point_reward | effect_standard | B-tree      | 用于按生效标准筛选积分奖励规则 |
| idx_zjk_point_reward_is_forever      | zjk_point_reward | is_forever      | B-tree      | 用于筛选是否永久生效的积分奖励 |
| idx_zjk_point_reward_id              | zjk_point_reward | ID              | Primary Key | 主键索引，唯一标识积分奖励记录 |

## zjk_review_phase 表索引


| 索引名称                                | 表名             | 字段               | 索引类型    | 描述                           |
| --------------------------------------- | ---------------- | ------------------ | ----------- | ------------------------------ |
| idx_zjk_review_phase_item_extreation_id | zjk_review_phase | item_extreation_id | B-tree      | 外键索引，关联抽取ID           |
| idx_zjk_review_phase_parent_id          | zjk_review_phase | parent_id          | B-tree      | 用于筛选父评审阶段             |
| idx_zjk_review_phase_effective          | zjk_review_phase | effective          | B-tree      | 用于筛选有效/无效评审阶段      |
| idx_zjk_review_phase_id                 | zjk_review_phase | id                 | Primary Key | 主键索引，唯一标识评审阶段记录 |

## zjk_product_summarize 表索引


| 索引名称                                         | 表名                  | 字段                   | 索引类型    | 描述                           |
| ------------------------------------------------ | --------------------- | ---------------------- | ----------- | ------------------------------ |
| idx_zjk_product_summarize_expert_ids             | zjk_product_summarize | expert_ids             | B-tree      | 外键索引，关联专家ID列表       |
| idx_zjk_product_summarize_product_summarize_type | zjk_product_summarize | product_summarize_type | B-tree      | 用于筛选总结类型               |
| idx_zjk_product_summarize_id                     | zjk_product_summarize | id                     | Primary Key | 主键索引，唯一标识项目总结记录 |

## 总结

以上索引设计基于 `zjk.sql` 文件中提供的字段注释和实际业务需求，确保关键字段具备高效的查询、筛选和关联能力。
