package org.dromara.zjk.domain;

import org.dromara.common.tenant.core.TenantEntity;
import com.baomidou.mybatisplus.annotation.*;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serial;

/**
 * 业务数据变更记录对象 zjk_data_changes_logs
 *
 * @author ygh
 * @date 2024-11-07
 */
@Data
@EqualsAndHashCode(callSuper = true)
@TableName("zjk_data_changes_logs")
public class ZjkDataChangesLogs extends TenantEntity {

    @Serial
    private static final long serialVersionUID = 1L;

    /**
     * id
     */
    private Long id;

    /**
     * 操作类型
     */
    private String changeType;

    /**
     * 业务类型 1.专家信息变更 2.项目信息变更
     */
    private String businessType;

    /**
     * 操作前数据
     */
    private String beforeOper;

    /**
     * 操作后数据
     */
    private String afterOper;

    /**
     * 操作 ip
     */
    private String operIp;

    /**
     * 逻辑删除
     */
    @TableLogic
    private Long delFlag;


}
