package org.dromara.zjk.domain.vo;

import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.alibaba.excel.annotation.ExcelIgnoreUnannotated;
import com.alibaba.excel.annotation.ExcelProperty;
import org.dromara.common.excel.annotation.ExcelDictFormat;
import org.dromara.common.excel.convert.ExcelDictConvert;
import io.github.linpeilie.annotations.AutoMapper;
import lombok.Data;
import org.dromara.zjk.domain.ZjkProjectEvaluation;

import java.io.Serial;
import java.io.Serializable;
import java.util.Date;



/**
 * 项目总结评价视图对象 zjk_project_evaluation
 *
 * @author ygh
 * @date 2024-11-08
 */
@Data
@ExcelIgnoreUnannotated
@AutoMapper(target = ZjkProjectEvaluation.class)
public class ZjkProjectEvaluationVo implements Serializable {

    @Serial
    private static final long serialVersionUID = 1L;

    /**
     * 主键
     */
    @ExcelProperty(value = "主键")
    private Long id;

    /**
     * 项目总结id
     */
    @ExcelProperty(value = "项目总结id")
    private Long productSummarizeId;

    /**
     * 目标达成
     */
    @ExcelProperty(value = "目标达成")
    private Long goalAchievement;

    /**
     * 交付质量
     */
    @ExcelProperty(value = "交付质量")
    private Long deliveryQuality;

    /**
     * 成本控制
     */
    @ExcelProperty(value = "成本控制")
    private Long costControl;

    /**
     * 风险管理
     */
    @ExcelProperty(value = "风险管理")
    private Long riskManagement;

    /**
     * 项目价值
     */
    @ExcelProperty(value = "项目价值")
    private Long projectValue;

    /**
     * 项目总结评价文件id集合
     */
    @ExcelProperty(value = "项目总结评价文件id集合")
    private String evaluateFile;

    /**
     * 租户号
     */
    @ExcelProperty(value = "租户号")
    private String tenantId;

    /**
     * 乐观锁
     */
    @ExcelProperty(value = "乐观锁")
    private Long REVISION;

    /**
     * 创建人
     */
    @ExcelProperty(value = "创建人")
    private String createdBy;

    /**
     * 创建时间
     */
    @ExcelProperty(value = "创建时间")
    private Date createdTime;

    /**
     * 更新人
     */
    @ExcelProperty(value = "更新人")
    private String updatedBy;

    /**
     * 更新时间
     */
    @ExcelProperty(value = "更新时间")
    private Date updatedTime;

    /**
     * 项目总结评价
     */
    @ExcelProperty(value = "项目总结评价")
    private String projectSummaryEvaluation;


}
