package org.dromara.zjk.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 *  审核状态 通用枚举类
 *  10=待审核 20=审核被拒 90=草稿 100=审核通过
 * @author Will
 */
@Getter
@AllArgsConstructor
public enum AuditStatusEnum implements BaseEnum {

    UN_AUDIT(10,"待审核"),
    REFUSED(20,"审核被拒"),
    DRAFT(90,"草稿"),
    APPROVED(100,"审核通过"),
    ;

    private Integer value;
    private String name;

}
