package org.dromara.zjk.expert.retirementRecords.domain;

import com.baomidou.mybatisplus.annotation.TableLogic;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.dromara.common.tenant.core.TenantEntity;
import org.dromara.zjk.annotation.PropertyMsg;

import java.io.Serial;
import java.util.Date;

/**
 * 专家退休记录对象 zjk_retirement_records
 *
 * @author zhangzhou
 * @date 2024-11-19
 */
@Data
@EqualsAndHashCode(callSuper = true)
@TableName("zjk_retirement_records")
public class ZjkRetirementRecords extends TenantEntity {

    @Serial
    private static final long serialVersionUID = 1L;

    /**
     * id
     */
    @PropertyMsg(propertyName = "id")
    private Long id;

    /**
     * 专家 id
     */
    @PropertyMsg(propertyName = "专家 id")
    private Long expertId;

    /**
     * 用户 id
     */
    @PropertyMsg(propertyName = "用户 id")
    private Long userId;

    /**
     * 退休时间
     */
    @PropertyMsg(propertyName = "退休时间")
    private Date retirementTime;

    /**
     * 专家状态 4 离职 5退休
     */
    @PropertyMsg(propertyName = "专家状态")
    private String expertStatus;


    /**
     * 离职原因
     */
    @PropertyMsg(propertyName = "离职原因")
    private String  reason;

    /**
     * 附件
     */
    @PropertyMsg(propertyName = " 附件")
    private String filePath;


    /**
     * 逻辑删除
     */
    @TableLogic
    @PropertyMsg(propertyName = "del_flag")
    private Long delFlag;


}
