package org.dromara.zjk.learning_world.domain.entity;

import org.dromara.common.tenant.core.TenantEntity;
import com.baomidou.mybatisplus.annotation.*;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serial;
import java.util.Date;

/**
 * 课程对象 zjk_learning_course
 *
 * @author ygh
 * @date 2024-11-08
 */
@Data
@EqualsAndHashCode(callSuper = true)
@TableName("zjk_learning_course")
public class ZjkLearningCourse extends TenantEntity {

    @Serial
    private static final long serialVersionUID = 1L;

    /**
     * id
     */
    private Long id;

    /**
     * 课程名称
     */
    private String courseName;

    /**
     * 课程分类
     */
    private String courseClassify;

    /**
     * 授课方式
     */
    private String teachingType;

    /**
     * 课程简介
     */
    private String courseBrief;

    /**
     * 课程图片
     */
    private String coursePic;

    /**
     * 状态
     */
    private String status;

    /**
     * 备注
     */
    private String remark;

    /**
     * 是否删除
     */
    @TableLogic
    private Long delFlag;

    /**
     * 附件
     */
    private String courseAttachment;

    /**
     * 上下架时间
     */
    private Date takedownTime;

    /**
     * 创建人
     */
    private Long userId;

    /**
     * 领域
     */
    private String performWorkId;
}
