package org.dromara.zjk.service.impl;

import cn.hutool.core.bean.BeanUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.dromara.common.core.constant.UserConstants;
import org.dromara.common.core.domain.R;
import org.dromara.common.satoken.utils.LoginHelper;
import org.dromara.zjk.domain.ZjkExpert;
import org.dromara.zjk.domain.ZjkExpertChart;
import org.dromara.zjk.domain.ZjkPointUser;
import org.dromara.zjk.domain.dto.SimpleExpertDto;
import org.dromara.zjk.domain.vo.ChartBaseVO;
import org.dromara.zjk.domain.vo.ChartRelExpertVO;
import org.dromara.zjk.domain.vo.PointShowVO;
import org.dromara.zjk.mapper.ZjkExpertChartMapper;
import org.dromara.zjk.mapper.ZjkExpertMapper;
import org.dromara.zjk.mapper.ZjkPointUserMapper;
import org.dromara.zjk.service.ZjkExpertChartService;
import org.dromara.zjk.service.ZjkPointRewardService;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import javax.annotation.Resource;
import java.util.List;

/**
 * @author EDY
 * @description 针对表【zjk_expert_chart(专家画像)】的数据库操作Service实现
 * @createDate 2024-11-13 10:20:57
 */
@Service
public class ZjkExpertChartServiceImpl extends ServiceImpl<ZjkExpertChartMapper, ZjkExpertChart>
    implements ZjkExpertChartService {
    @Resource
    private ZjkPointUserMapper zjkPointUserMapper;
    @Resource
    private ZjkExpertMapper zjkExpertMapper;
    @Resource
    private ZjkPointRewardService zjkPointRewardService;
    @Resource
    private ZjkExpertChartMapper ZjkExpertChartMapper;

    @Override
    public R<ChartBaseVO> getChartBase(Long userId) {
        LambdaQueryWrapper<ZjkExpert> wq = new LambdaQueryWrapper<ZjkExpert>()
            .eq(ZjkExpert::getUserId, userId == null ? LoginHelper.getUserId() : userId)
            .eq(ZjkExpert::getDeleteFlag, UserConstants.DEL_FLAG_NORMAL)
            .eq(ZjkExpert::getStatus, 2)
            .last("limit 1");
        ZjkExpert zjkExpert = zjkExpertMapper.selectOne(wq);
        if (zjkExpert != null) {
            ChartBaseVO result = new ChartBaseVO();
            BeanUtil.copyProperties(zjkExpert, result);
            //积分title设置
            QueryWrapper<ZjkPointUser> zj = new QueryWrapper<>();
            zj.lambda().eq(ZjkPointUser::getUserId, LoginHelper.getUserId());
            PointShowVO rdata = zjkPointUserMapper.getRankAndPoint(userId == null ? LoginHelper.getUserId(): userId);
            if (rdata != null) {
                result.setPoints(rdata.getPoints());
                result.setRank(rdata.getRank());
                result.setRewardTitle(zjkPointRewardService.getRewardTitle(rdata.getExpertId(), rdata.getPoints()));
            }
            result.setMajor(ZjkExpertChartMapper.getExpertMajor(zjkExpert.getExpertId()));
            result.setProSkills(ZjkExpertChartMapper.getProSkills(zjkExpert.getExpertId()));
            result.setCreditName(ZjkExpertChartMapper.getCreditTitle(zjkExpert.getExpertId()));
            //设置画像
            QueryWrapper<ZjkExpertChart> cwq = new QueryWrapper<>();
            cwq.lambda().eq(ZjkExpertChart::getUserId, userId == null ? LoginHelper.getUserId() : userId)
                .last("limit 1");
            ZjkExpertChart zjkExpertChart = ZjkExpertChartMapper.selectOne(cwq);
            result.setChart(zjkExpertChart);
            return R.ok(result);
        }

        return R.ok(null);
    }

    @Override
    public void handleExpertChart() {
        //先删除
        ZjkExpertChartMapper.removeAll();
        //插入新的用户画像数据
        List<ZjkExpertChart> vo = ZjkExpertChartMapper.getHandleData();
        this.saveBatch(vo);
    }

    @Override
    public R<ChartRelExpertVO> getSameOtherData(Long userId) {
        ChartRelExpertVO chartRelExpertVO = new ChartRelExpertVO();
        if (userId == null) {
            userId = LoginHelper.getUserId();
        }
        SimpleExpertDto simpleExpertDto = new SimpleExpertDto();

        LambdaQueryWrapper<ZjkExpert> wq = new LambdaQueryWrapper<ZjkExpert>()
            .eq(ZjkExpert::getUserId, userId == null ? LoginHelper.getUserId() : userId)
            .eq(ZjkExpert::getDeleteFlag, UserConstants.DEL_FLAG_NORMAL)
            .eq(ZjkExpert::getStatus, 2);
        ZjkExpert zjkExpert = zjkExpertMapper.selectOne(wq);
        if (zjkExpert != null) {
            Long expertId = zjkExpert.getExpertId();
            simpleExpertDto.setExpertId(zjkExpert.getExpertId());
            simpleExpertDto.setExpertName(zjkExpert.getExpertName());
            chartRelExpertVO.setCurUser(simpleExpertDto);
            List<SimpleExpertDto> sameSchool = ZjkExpertChartMapper.getSameSchoolExperts(expertId);
            List<SimpleExpertDto> sameUnit = ZjkExpertChartMapper.getSameUnitExperts(expertId);
            List<SimpleExpertDto> samePro = ZjkExpertChartMapper.getSameProExperts(expertId);
            chartRelExpertVO.setSchoolUsers(sameSchool);
            chartRelExpertVO.setWorkUsers(sameUnit);
            chartRelExpertVO.setPerformUsers(samePro);
        }


        return R.ok(chartRelExpertVO);
    }

    @Override
    public R<List<SimpleExpertDto>> getExperts() {
        LambdaQueryWrapper<ZjkExpert> wq = new LambdaQueryWrapper<ZjkExpert>()
            .eq(ZjkExpert::getDeleteFlag, UserConstants.DEL_FLAG_NORMAL)
            .eq(ZjkExpert::getStatus, 2);
        List<ZjkExpert> zjkExpert = zjkExpertMapper.selectList(wq);
        List<SimpleExpertDto> simpleExpertDtos = null;
        if(!CollectionUtils.isEmpty(zjkExpert)){
            simpleExpertDtos = BeanUtil.copyToList(zjkExpert, SimpleExpertDto.class);

        }
        return R.ok(simpleExpertDtos);
    }

}




