







**肾移植的相关知识**





一

**什么是肾移植**



肾移植，也就是我们老百姓所说的换肾。顾名思义，它是将一个有功能的肾移植到一个肾脏功能已经丧失的患者身上。目前，肾移植是所有器官移植中成功率最高、预后最好的手术。那么，肾移植究竟是怎么做的呢？是把原来的肾切掉，换一个新的吗？大多数人可能会有这样一个疑问。

其实啊，肾移植手术并不是将新肾脏放在原来肾脏的位置，而是放在我们人体的髂窝处。为什么选择放在这个地方呢？是不是感觉怪怪的？之所以选择髂窝，是因为放在这里好处多多。

![](https://ncstatic.clewm.net/rsrc/2024/0120/21/a5c3afb2805cf6124719fac1c4e18573.png)





第一

此处血管相对较浅，容易与新肾脏的血管相接，手术操作简单易行，这大大增加了手术的成功率。







第二

整个手术过程未进入腹腔，术后合并症少。







第三

移植肾位置表浅，既可以通过触摸来感受其大小及硬度，方便医生及时判断有无排斥反应等，术后又可以随时进行超声检查，观察新肾的血流情况，还有利于进行肾穿刺活检，可谓一举多得。







第四

如果发生了并发症或者其他意外情况，便于二次手术。当然了，凡事有利就有弊。正是因为位置表浅，所以它比较容易受伤，因此进行了肾移植的患者在平时的日常生活中一定要格外注意保护好自己的新肾。



看到这里，可能有人还会有一个疑问，那就是原来的肾要不要切掉呢？关于这个问题，我们原则上是不主张切掉的，这主要基于两个方面的考虑，首先，原来的肾脏虽然已经衰竭，不足以维持人体的功能需要，但是仍然保留有一定的肾功能和内分泌功能。其次，切除病肾对患者来说本身就是一次比较大的创伤，会进一步增加手术风险和并发症，得不偿失。但是，如果病肾相关的疾病仍然存在，且由于病肾的存在造成人体健康进一步损害，那么这个时候，我们就要权衡利弊，考虑是否切除病肾了。

付费专享





二

**什么样的慢性肾功能衰竭患者适宜进行肾脏移植？**



原则上任何肾脏疾病发展至不可逆的肾功能衰竭阶段，经各种保守治疗无效，血肌酐持续在700umol/L以上，必须靠透析治疗维持生命的患者，均宜行肾移植术。其与一般外科手术一样，要求患者除肾脏外的其他各系统及各器官无严重损害，全身情况能耐受肾脏移植手术及麻醉的打击。

此外，患者还应符合以下要求：年龄在18-65岁，膀胱和下尿路的解剖结构及功能正常，无精神疾病，无严重凝血功能不良，无呼吸功能衰竭，无活动性感染或结核病，无活动性消化道溃疡，无活动性肝炎及肝硬化，无明显心血管并发症，无恶性肿瘤，能耐受免疫抑制剂治疗。如患者一般健康状况良好，年龄也可适当放宽。





三

**接受肾移植手术有哪些条件？**

01

年龄。现阶段对于年龄没有明确的限制，我国目前年龄最小的一例肾移植患者仅2个月26天。当年龄大于60岁时，就需要严格评估患者的心肺肝脏以及血管等的功能，判断患者是否耐受，所承担的手术风险也更大。

02

活动性肝炎的患者不能做肾移植。但是对于肝炎病毒携带者来说（乙型肝炎病毒表面抗原阳性）则有争议，最好能根据肝穿刺结果来确定。已确诊的肝硬化患者不宜做肾移植。

03

冠心病、不稳定性心绞痛的患者一般不宜马上做肾移植。对于有明显症状的冠心病患者应先行冠状动脉造影评估，必要时“搭桥”手术成功后再接受肾移植。

04

活动性消化性溃疡的患者不适宜马上做移植。由于术后要使用大量激素，因此术前必须将溃疡治愈。

05

体内有活动性慢性感染病灶的患者，应先系统治疗，控制稳定后再做肾移植。

06

患者有恶性肿瘤且已发生转移的患者禁忌行移植，因为免疫抑制可能使肿瘤发展或复发。

07

因为移植后需要终生维持治疗，患有精神性疾病、患者依从性差的患者，不能考虑肾脏移植。





四

**肾移植术前需要做哪些准备？**

01

充分透析

第一点，也是非常重要的一点，由于慢性肾功能衰竭的程度不同，每个人透析的时间也不一样。但是无论如何，都要在术前进行一次充分的透析，来纠正体内肌酐等电解质紊乱，维持内环境稳定。这样做的好处是可以提高患者术中的耐受性。

02

控制血压

肾功能衰竭患者往往伴有高血压，长期口服降压药。如果血压过高，则容易引起术后出血，过低则会导致心、肾等灌注不足。因此术前要积极的控制血压，患者需要将自己平时所吃的所有降压药告知医生，由医生来决定吃什么药，怎么吃，万万不可自己擅自停药。

03

纠正贫血

肾性贫血是终末期肾病患者的常见并发症，一般建议在术前治疗并补充铁剂，避免多次输血而导致潜在的病毒感染。

04

术前肠道准备

与其他全麻手术一样，术前一晚应进食清淡饮食。当晚12点以后禁食水。在等待进入手术室的过程中，若感到明显饥饿，告知主管医生，可输注糖水或糖盐补充能量。

05

术前检验检查

除了配型所需的抽血之外，还需要进行肝肾功、凝血功能、心功能、传染病等的抽血检验，此外，还需要配合完成心电图、胸片、肝胆胰脾肾超声、心脏超声等相关检查。

06

思想准备

思想上一定要重视起来，毕竟这关乎自己的生命。但是有句话叫过犹不及。千万不要过度的焦虑与紧张，当遇到不明白的问题或者有不舒服的地方，一定要及时和自己的主管大夫沟通。





五

**肾移植术后如何做好在院期间的防护？**

01

术后病情监测

因为刚刚经历了大手术，所以人体的免疫力较低，容易感染。此时需要严密监测各项生命体征。包括佩戴心电监护仪、吸氧、输液、测量血压、血糖等，同时还需要记录每日的尿量，这个尤其重要，医生可以根据这个来判断肾功能恢复情况，从而调整临床用药。

02

留置导尿管

相信很多人可能对这个比较陌生，但导尿管在肾移植患者术后恢复过程中却起了非常大的作用，不可缺少。

![](https://ncstatic.clewm.net/rsrc/2024/0120/21/0243d1179b69dd4aa61759fa31fecfb2.png)





如图所示，这个软软的硅胶管就是尿管。一般在手术前，麻醉后，医生会将导尿管经患者尿道放入膀胱，引流膀胱里的尿液。如果术后不小心脱落，则需要重新插入。这个小小的管子，真有这么大的作用？其实，它的作用远不止此。首先，医生可以通过它来观察引流尿液的颜色以及每小时的尿量，从而判断移植肾的功能恢复情况。

其次，由于肾移植手术中会做移植肾输尿管与膀胱的吻合，同时会置入支架管来支撑，若没有此根引流管，导致膀胱里的尿液不能及时排出，就很有可能会反流入新肾脏，对肾功能造成影响。所以术后每个肾移植患者都要佩戴一段时间。

你可能会问了，什么时候拔掉？一般来说，术后5~7天就可拔除导尿管，而且留置时间过长还会增加感染的风险，但是需要具体情况具体分析，由主管大夫根据术后恢复情况来决定什么时候拔掉。

03

留置血液引流管

除了导尿管，您的身上还要插入引流管，这跟管子同样非常重要。手术后伤口区域组织渗血以及淋巴漏在所难免，若不能及时的引流出来，在体内积聚会不利于伤口愈合，且由于压力增大，会对移植肾产生不利影响，因此在关闭伤口前，会在你的手术切口部位放置引流管，来引流血液及淋巴液等。而这根管子什么时候拔，也需要您的主管大夫根据其引流量来决定。

04

术后伤口护理

肾移植术后会留下一个长长的伤口。当您麻醉苏醒后，会慢慢的感受到疼痛，而且还会越来越痛。出现这种情况，你一定不要紧张。这都属于正常现象，如果不疼反而不正常。如果你能耐受这个痛感，可以不必做任何处理，但是若疼的受不了，比如晚上不能睡觉，那您就需要告知大夫，给予止痛药。主管大夫会对伤口定期换药，以此来预防感染。

05

术后饮食

一般来说，术后第一天，如果没有腹痛腹胀等，可先喝少量水。饮水后若仍无以上不适，即可恢复饮食，先从流食开始，可以喝点汤，牛奶，逐渐过渡到半流食，如面条，粥等，最后再是普食。要注意，这个是循序渐进的过程，切不可操之过急。由于术后1~3天肾功能尚未恢复完全，应当适当限制蛋白质的摄入量，每天约24g，以鱼、禽、蛋、瘦肉类为主。如果尿量较多，每天的食盐可不用严格限制。忌烟酒：因烟酒损伤血管，可对移植肾产生破坏。

06

术后检验检查

为了及时的了解移植肾的恢复情况以及预防排斥反应，除了观察记录尿量以外，就是要抽血检验了，肾移植术后早期会频繁的抽血，抽血的主要项目有：血常规、肝肾功、血药浓度、凝血功能等。不过你不要过度担心，抽血不仅不会有害，反而会刺激你的造血系统，对人体有利。除了抽血，适时的进行移植肾血流超声检查也是必不可少的，有利于及早发现血流异常，早发现早处理。

07

术后活动

术后长期卧床会增加下肢静脉血栓的风险，因此需要尽早的下地活动。一般术后第二天即可下地进行适量的活动。锻炼要量力而行，循序渐进，当你感觉明显的喘憋、劳累时，一定要及时坐下或者躺下休息。活动时最好能有人搀扶，防止跌倒。





六

**肾移植术后有哪些并发症？**



**01** **/ 术后感染**

肾移植和大多数开腹手术一样，会有一些并发症，例如感染、出血、高血压、淋巴瘘等。但是肾移植一个非常大的不同是，病人术后需要长期服用糖皮质激素以及免疫抑制剂，这导致患者抵抗力比较低，因此肾移植病人最常见的并发症就是感染，以肺部感染多见。所以肾移植病人在出院回家后，为了预防感染，应做到以下几点：

1、定期按时复查血药浓度，以此来及时掌握机体的免疫状态，避免免疫力过低，降低感染风险。

2、尽量避免在公共场所过多停留、出门戴口罩、较少不必要的聚餐等活动。

3、适量的体育锻炼，有利于增强体质。

4、家里有养小动物或者家禽的一定要注意了，这些都是高风险的感染源，所以为了自身的健康，出院回家一定要避免和这类动物接触。

5、当发现自己有发烧、咳嗽等肺部感染常见症状后，一定要和你的主管大夫取得联系，及时向他汇报自己的病情，必要时来医院做检查，切记不可盲目自行服药。



**02** **/ 排斥反应**

什么是排斥反应呢？简单的说，新移植的肾脏相对于我们人体来说就是个“异物”，当它进入人体后，受到体内淋巴细胞为主的免疫细胞的“攻击”，这就是医学上的排斥反应，这也是目前导致移植肾失去功能的一个最主要原因。



**03 /** **腹泻**

这主要是因为药物的不良反应。前面我们已经说到，术后患者会有感染的发生，进而可以导致腹泻；当出现感染，服用抗生素治疗时，又有可能导致抗生素相关性腹泻；患者术后需要长期服用免疫抑制剂，例如吗替麦考酚脂胶囊，这一药物最常见的副作用就是腹泻。腹泻可以导致药物浓度降低，增加排斥反应的风险，因此需要引起我们的重视，千万不能大意。当出现腹泻时，可以按说明书服用止泻药，如蒙脱石散等。若腹泻仍不好转，及时与自己的主管大夫取得联系，积极治疗。





七

**免疫抑制药物应该如何选择？**



移植后，您就会和一个药物形影不离，它就是免疫抑制剂，有人称之为移植患者生命健康的“领航员”。现如今都实行个体化治疗方案，医生会根据每个患者自身情况选用二种或三种免疫抑制剂联合应用抗排斥治疗，这样可以尽可能地把多种药物的有效应用剂量控制在最低水平，以减少每一种药物的毒性反应，并通过联合用药实现有效抗排斥。但是长期服用免疫抑制剂，如果服用剂量不足，达不到有效血药浓度，会发生急性或慢性排斥，影响移植肾长期存活。如果服用剂量过多，会降低患者的抗感染能力，易于合并严重感染，或出现药物毒副作用。因而必须定期随访，进行肝肾功能、血药浓度等全面检查，在医生指导下调整免疫抑制剂用药剂量。切勿长期不进行随访检查，切勿随意改药、减药、或自行停药。

**除了以上这些，****还需要额外注意以下几点：**

01

1、避免食用西柚和西柚汁。因为西柚会显著提高体内免疫抑制剂的浓度，这是经过临床证实的，长期食用会造成免疫抑制剂的浓度失调，从而导致我们的肾功能损伤！所以能不食用就不食用，最好杜绝。

02

不要随意服用布洛芬、萘普生或其他任何的NSAID（非甾体类抗炎药），因为它们和环孢素A或他克莫司合用会损伤肾脏。其他可影响免疫抑制效果的药物还包括：红霉素、阿奇霉素、克拉霉素等等。所以大家在平时使用非免疫抑制剂的时候，尽量多做一些了解。

03

千万不要在未得到自己的主管医生同意的情况下服用中药材或膳食补充剂以及其他任何形式的保健品。您想尽快恢复身体的心情我们能理解，但是许多中药材或非处方的膳食补充剂（如鹿茸，蜂王浆，复合维生素等）和保健品等，这些较大程度上会提高我们的免疫功能，这是和免疫抑制剂作用目的背道而驰的。

04

不要在不同品牌的同一类药物间随意转换，因为不同厂家生产的同一类药物的免疫抑制效果可能会有一定的差异。这些差异可大可小，包括会有不同的作用，副作用等。在换药之前要做好充分的了解并且和主管大夫做好充分的沟通。





八

**出院随访及复查该注意些什么？**





复查频率

出院3个月以内，每周/次；3~6个月，每半月/次；6个月~1年，每月/次；1~2年，每2~3个月/次。这是比较基本的复查频率。但是每个医院，每个病人情况不一样，需要具体来分析。但是有个原则，就是随时有情况，就要随时来医院，切莫耽误病情。







复查内容

每次复查时，医生都需要了解你在家的一些基本情况，包括血压的情况啊，尿量的变化，服药情况，以及一些特殊情况，比如腹泻啊，发烧啊等等，所以病人需要提前记录好这些内容，复查的时候给医生看。







复查项目

主要是抽血检验，血常规、肝肾功、免疫抑制剂血药浓度，因此需要你在复查的当天空腹来医院，记住，一定要空腹，不然就没法抽血化验了。





九

**肾移植术后如何坚持锻炼身体?**



术后三个月以内不可提重物或做仰卧起坐和类似的运动,亦不要做剧烈运动，例如;踢足球、游泳,以免拉扯腹部伤口及扭伤肌肉,三个月后，可以适当运动。有氧运动是最佳方式，如散步、骑固定自行车、跳舞、太极拳，严防移植肾外伤，养成良好的生活习惯，尽快恢复工作。





十

**肾移植后多久可以有性生活？可以生育吗？**



对于已婚的病人，只要身体适当恢复，可以过性生活，但决不能放纵，要适当克制。关于生育问题，如果您是男性，您的生育能力会逐渐恢复正常，根据文献报道和临床经验，服用免疫抑制药物不会影响到下一代。如果您是女性，可恢复生育能力，但不提倡生育。因为怀孕和生育会加重肾脏的负担，从而有可能导致肾功能不全。而且怀孕时子宫扩张会挤压盆腔里的肾脏，互相影响。

因此我们认为，肾移植后可以结婚，但应该注意避孕，生育问题必须慎重考虑。如果一定要有下一代，最好您与您的责任医师认真讨论后再决定。