package org.dromara.resource.api;

import jakarta.servlet.http.HttpServletResponse;
import org.dromara.common.core.exception.ServiceException;
import org.dromara.resource.api.domain.RemoteFile;

import java.io.IOException;
import java.util.List;

/**
 * 文件服务
 *
 * @author Lion Li
 */
public interface RemoteFileService {

    /**
     * 上传文件
     *
     * @param file 文件信息
     * @return 结果
     */
    RemoteFile upload(String name, String originalFilename, String contentType, byte[] file) throws ServiceException;

    /**
     * 通过ossId查询对应的url
     *
     * @param ossIds ossId串逗号分隔
     * @return url串逗号分隔
     */
    String selectUrlByIds(String ossIds);

    /**
     * 通过ossId查询列表
     *
     * @param ossIds ossId串逗号分隔
     * @return 列表
     */
    List<RemoteFile> selectByIds(String ossIds);
    /**
     * 文件下载打包为zip
     *
     * @param ossIds  OSS对象IDs
     * @param response HttpServletResponse对象，用于设置响应头和向客户端发送文件内容
     */
    void downloadToZip(List<Long> ossIds, HttpServletResponse response) throws IOException;
    /**
     * 文件下载
     *
     * @param ossId  OSS对象ID
     * @param response HttpServletResponse对象，用于设置响应头和向客户端发送文件内容
     */
    void downloadOne(Long ossId, HttpServletResponse response) throws IOException;
}
