package org.dromara.zjk.domain;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import lombok.Data;
import org.dromara.common.mybatis.core.domain.BaseEntity;

/**
 * 积分记录
 * @TableName zjk_point
 */
@TableName(value ="zjk_point")
@Data
public class ZjkPoint extends BaseEntity{
    /**
     * 租户号
     */
    @TableId(value = "ID",type = IdType.AUTO)
    private Long id;

    /**
     * 积分数值
     */
    @TableField(value = "points")
    private BigDecimal points;

    /**
     * 积分事由外键
     */
    @TableField(value = "rule_id")
    private Long ruleId;
    /**
     * 用户id
     */
    @TableField(value = "user_id")
    private Long userId;

    /**
     * 专家id
     */
    @TableField(value = "expert_id")
    private Long expertId;

    /**
     * 积分来源评价id
     */
    @TableField(value = "evaluate_id")
    private String evaluateId;

    @TableField(exist = false)
    private static final long serialVersionUID = 1L;

    private String hmac;
}
