package org.dromara.zjk.domain.bo;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.github.linpeilie.annotations.AutoMapper;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.dromara.common.mybatis.core.domain.BaseEntity;
import org.dromara.zjk.domain.ZjkLeave;

import java.util.Date;

/**
 * 【请填写功能名称】业务对象 zjk_leave
 *
 * @author ygh
 * @date 2024-10-30
 */
@Data
@EqualsAndHashCode(callSuper = true)
@AutoMapper(target = ZjkLeave.class, reverseConvertGenerate = false)
public class ZjkLeaveBo extends BaseEntity {

    /**
     * $column.columnComment
     */
    private String gid;

    /**
     * $column.columnComment
     */
    private String leaveType;
    @JsonFormat(timezone = "UTC",pattern="yyyy-MM-dd")
    private Date startDate;

    @JsonFormat(timezone = "UTC",pattern="yyyy-MM-dd")
    private Date endDate;

    /**
     * $column.columnComment
     */
    private Long leaveDays;

    /**
     * $column.columnComment
     */
    private String leaveReason;

    /**
     * 0 待审批 1 通过 2驳回
     */
    private String status;

    /**
     * $column.columnComment
     */
    private String approvalUser;

    /**
     * $column.columnComment
     */
    private String approvalMsg;

    /**
     * 租户ID
     */
    private String tenantId;


}
