package org.dromara.zjk.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 *专家库枚举类
 */
@Getter
@AllArgsConstructor
public enum ZjkExpertTypeEnum {
    /**
     * 状态: 0：暂存 1：待审批 2：正常  3：拒绝
     */
    //暂存
    STAGING(0,"暂存"),
    //待审批
    APPROVAL(1,"待审批"),
    //正常
    NORMAL(2,"正常"),
    //拒绝
    REFUSE(3,"拒绝"),

    //离职
    ESIGN(4,"离职"),
    // 退休
    RETIRE(5,"退休");

    /**
     * 状态
     */
    private final int code;

    /**
     * 描述
     */
    private final String desc;

    public String getCodeAsString() {
        return String.valueOf(this.code);
    }
}
