package org.dromara.zjk.expert.expertAwards.domain.vo;

import com.alibaba.excel.annotation.ExcelIgnoreUnannotated;
import com.alibaba.excel.annotation.ExcelProperty;
import io.github.linpeilie.annotations.AutoMapper;
import lombok.Data;
import org.dromara.zjk.expert.expertAwards.domain.ZjkExpertAwards;

import java.io.Serial;
import java.io.Serializable;



/**
 * 专家获奖情况视图对象 zjk_expert_awards
 *
 * @author zhangzhou
 * @date 2024-11-10
 */
@Data
@ExcelIgnoreUnannotated
@AutoMapper(target = ZjkExpertAwards.class)
public class ZjkExpertAwardsVo implements Serializable {

    @Serial
    private static final long serialVersionUID = 1L;

    /**
     * id
     */
    @ExcelProperty(value = "id")
    private Long id;

    /**
     * 专家 id
     */
    @ExcelProperty(value = "专家 id")
    private Long expertId;

    /**
     * 获奖证书文件路径
     */
    @ExcelProperty(value = "获奖证书文件路径")
    private String awardsPath;

    /**
     * 获奖内容
     */
    @ExcelProperty(value = "获奖内容")
    private String awardsContent;

    /**
     * 原名
     */
    private String originalName;

    /**
     * 文件后缀名
     */
    private String fileSuffix;

    private String registerSn;
}
