package org.dromara.zjk.learning_world.domain.vo;

import java.math.BigDecimal;
import java.util.Date;

import com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.poi.hpsf.Decimal;
import org.dromara.zjk.learning_world.domain.entity.ZjkLearningRecords;
import com.alibaba.excel.annotation.ExcelIgnoreUnannotated;
import com.alibaba.excel.annotation.ExcelProperty;
import io.github.linpeilie.annotations.AutoMapper;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serial;
import java.io.Serializable;


/**
 * 学习记录视图对象 zjk_learning_records
 *
 * @author wt
 * @date 2024-11-26
 */
@Data
@ExcelIgnoreUnannotated
@AutoMapper(target = ZjkLearningRecords.class)
public class ZjkLearningRecordsVo implements Serializable {

    @Serial
    private static final long serialVersionUID = 1L;

    /**
     * id
     */
    @ExcelProperty(value = "id")
    private Long id;

    /**
     * 课程id
     */
    @ExcelProperty(value = "课程id")
    private Long courseId;
    @ExcelProperty(value = "课程名称")
    private String courseName;

    /**
     * 用户id
     */
    @ExcelProperty(value = "用户id")
    private Long userId;

    /**
     * 专家id
     */
    @ExcelProperty(value = "专家id")
    private Long expertId;

    /**
     * 视频时长
     */
    @ExcelProperty(value = "视频时长")
    @JsonFormat(pattern = "HH:mm:ss",timezone="GMT+8")
    @DateTimeFormat(pattern = "HH:mm:ss")
    private Date rate;

    /**
     * 观看时长
     */
    @ExcelProperty(value = "观看时长")
    @JsonFormat(pattern = "HH:mm:ss",timezone="GMT+8")
    @DateTimeFormat(pattern = "HH:mm:ss")
    private Date viewDuration;

    /**
     * 学习时长
     */
    private Long learningSessionLength;
    /**
     * 状态
     */
    @ExcelProperty(value = "状态")
    private String status;

    /**
     * 备注
     */
    @ExcelProperty(value = "备注")
    private String remark;

    private Decimal expertLearningHours;

    private String expertName;

    /**
     * 学时
     */
    private BigDecimal learningHours;


    /**
     * 系统学时
     */
    private BigDecimal systemLearningHours;

    /**
     * 是否达标
     */
    private Boolean compliance;
}
