package org.dromara.zjk.mapper;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.apache.ibatis.annotations.Param;
import org.dromara.zjk.domain.ZjkPoint;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import org.dromara.zjk.domain.dto.PointReqDto;
import org.dromara.zjk.domain.vo.PointShowVO;
import org.dromara.zjk.domain.vo.ZjkEvaluateVO;
import org.dromara.zjk.domain.vo.ZjkPointVO;

import java.math.BigDecimal;
import java.util.List;

/**
* @author EDY
* @description 针对表【zjk_point(积分记录)】的数据库操作Mapper
* @createDate 2024-11-06 16:29:59
* @Entity org.dromara.zjk.domain.ZjkPoint
*/
public interface ZjkPointMapper extends BaseMapper<ZjkPoint> {

    IPage<PointShowVO> queryPointList(Page<Object> build, @Param("bo") PointReqDto bo);

    IPage<ZjkPointVO> queryPointDetail(Page<Object> build, @Param("bo") PointReqDto bo);

    BigDecimal getPointByDate(String date, String expertId);

    IPage<PointShowVO> getCheckPointList(Page<Object> build, PointReqDto bo);
    List<PointShowVO> getCheckWaitPointList( @Param("bo")PointReqDto bo);

    void clearUnPresentData(List<String> evaIds);

    List<ZjkPoint> getPointsByClearData(List<String> evaIds);
}




