package org.dromara.zjk.service;

import org.dromara.zjk.domain.ZjkCreditReward;
import org.dromara.zjk.domain.bo.ZjkCreditRuleBo;
import org.dromara.zjk.domain.vo.ZjkCreditRewardVo;
import org.dromara.zjk.domain.bo.ZjkCreditRewardBo;
import org.dromara.common.mybatis.core.page.TableDataInfo;
import org.dromara.common.mybatis.core.page.PageQuery;
import org.dromara.zjk.domain.vo.ZjkCreditRuleVo;

import java.util.Collection;
import java.util.List;

/**
 * 信用奖励Service接口
 *
 * @author ygh
 * @date 2024-11-11
 */
public interface IZjkCreditRewardService {

    /**
     * 查询信用奖励
     *
     * @param ID 主键
     * @return 信用奖励
     */
    ZjkCreditRewardVo queryById(String ID);

    /**
     * 分页查询信用奖励列表
     *
     * @param bo        查询条件
     * @param pageQuery 分页参数
     * @return 信用奖励分页列表
     */
    List<ZjkCreditRewardVo> queryPageList(String name);

    /**
     * 查询符合条件的信用奖励列表
     *
     * @param bo 查询条件
     * @return 信用奖励列表
     */
    List<ZjkCreditRewardVo> queryList(ZjkCreditRewardBo bo);

    /**
     * 新增信用奖励
     *
     * @param bo 信用奖励
     * @return 是否新增成功
     */
    Boolean insertByBo(ZjkCreditRewardBo bo);

    /**
     * 修改信用奖励
     *
     * @param bo 信用奖励
     * @return 是否修改成功
     */
    Boolean updateByBo(ZjkCreditRewardBo bo);

    /**
     * 校验并批量删除信用奖励信息
     *
     * @param ids     待删除的主键集合
     * @param isValid 是否进行有效性校验
     * @return 是否删除成功
     */
    Boolean deleteWithValidByIds(Collection<String> ids, Boolean isValid);

    List<String> getRewardTitle(Long expertId, Long creditCount);

    List<ZjkCreditRuleVo> ruleList(ZjkCreditRuleBo bo);
}
