package org.dromara.zjk.statement.domain.bo;

import org.dromara.zjk.statement.domain.ZjkMoneyAnalyseStatement;
import org.dromara.common.mybatis.core.domain.BaseEntity;
import org.dromara.common.core.validate.AddGroup;
import org.dromara.common.core.validate.EditGroup;
import io.github.linpeilie.annotations.AutoMapper;
import lombok.Data;
import lombok.EqualsAndHashCode;
import jakarta.validation.constraints.*;
import java.math.BigDecimal;

/**
 * 报表分析业务对象 zjk_money_analyse_statement
 *
 * @author ygh
 * @date 2024-12-16
 */
@Data
@EqualsAndHashCode(callSuper = true)
@AutoMapper(target = ZjkMoneyAnalyseStatement.class, reverseConvertGenerate = false)
public class ZjkMoneyAnalyseStatementBo extends BaseEntity {

    /**
     * id
     */
    @NotNull(message = "id不能为空", groups = { AddGroup.class, EditGroup.class })
    private Long id;

    /**
     * 专家类型;专家类型
     */
    @NotBlank(message = "专家类型;专家类型不能为空", groups = { AddGroup.class, EditGroup.class })
    private String expertType;

    /**
     * 总费用;总费用
     */
    @NotNull(message = "总费用;总费用不能为空", groups = { AddGroup.class, EditGroup.class })
    private BigDecimal sumFee;

    /**
     * 占比;占比
     */
    @NotNull(message = "占比;占比不能为空", groups = { AddGroup.class, EditGroup.class })
    private BigDecimal proportion;

    /**
     * 变化趋势;变化趋势
     */
    @NotNull(message = "变化趋势;变化趋势不能为空", groups = { AddGroup.class, EditGroup.class })
    private BigDecimal tendency;

    /**
     * 状态
     */
    @NotBlank(message = "状态不能为空", groups = { AddGroup.class, EditGroup.class })
    private String status;

    /**
     * 备注
     */
    @NotBlank(message = "备注不能为空", groups = { AddGroup.class, EditGroup.class })
    private String remark;


    /**
     * 报表id
     */
    private Long statementId;
}
