package org.dromara.zjk.statement.service.impl;

import org.dromara.common.core.utils.MapstructUtils;
import org.dromara.common.core.utils.StringUtils;
import org.dromara.common.mybatis.core.page.TableDataInfo;
import org.dromara.common.mybatis.core.page.PageQuery;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import lombok.RequiredArgsConstructor;
import org.dromara.zjk.statement.domain.ZjkMoneyExpertStatement;
import org.springframework.stereotype.Service;
import org.dromara.zjk.statement.domain.bo.ZjkMoneyCollectStatementBo;
import org.dromara.zjk.statement.domain.vo.ZjkMoneyCollectStatementVo;
import org.dromara.zjk.statement.domain.ZjkMoneyCollectStatement;
import org.dromara.zjk.statement.mapper.ZjkMoneyCollectStatementMapper;
import org.dromara.zjk.statement.service.IZjkMoneyCollectStatementService;

import java.util.List;
import java.util.Map;
import java.util.Collection;

/**
 * 报表统计Service业务层处理
 *
 * @author wt
 * @date 2024-12-16
 */
@RequiredArgsConstructor
@Service
public class ZjkMoneyCollectStatementServiceImpl implements IZjkMoneyCollectStatementService {

    private final ZjkMoneyCollectStatementMapper baseMapper;

    /**
     * 查询报表统计
     *
     * @param id 主键
     * @return 报表统计
     */
    @Override
    public ZjkMoneyCollectStatementVo queryById(Long id){
        return baseMapper.selectVoById(id);
    }

    /**
     * 分页查询报表统计列表
     *
     * @param bo        查询条件
     * @param pageQuery 分页参数
     * @return 报表统计分页列表
     */
    @Override
    public TableDataInfo<ZjkMoneyCollectStatementVo> queryPageList(ZjkMoneyCollectStatementBo bo, PageQuery pageQuery) {
        LambdaQueryWrapper<ZjkMoneyCollectStatement> lqw = buildQueryWrapper(bo);
        Page<ZjkMoneyCollectStatementVo> result = baseMapper.selectVoPage(pageQuery.build(), lqw);
        return TableDataInfo.build(result);
    }

    /**
     * 查询符合条件的报表统计列表
     *
     * @param bo 查询条件
     * @return 报表统计列表
     */
    @Override
    public List<ZjkMoneyCollectStatementVo> queryList(ZjkMoneyCollectStatementBo bo) {
        LambdaQueryWrapper<ZjkMoneyCollectStatement> lqw = buildQueryWrapper(bo);
        return baseMapper.selectVoList(lqw);
    }

    private LambdaQueryWrapper<ZjkMoneyCollectStatement> buildQueryWrapper(ZjkMoneyCollectStatementBo bo) {
        Map<String, Object> params = bo.getParams();
        LambdaQueryWrapper<ZjkMoneyCollectStatement> lqw = Wrappers.lambdaQuery();
        lqw.eq(bo.getSumFee() != null, ZjkMoneyCollectStatement::getSumFee, bo.getSumFee());
        lqw.eq(bo.getNoPayMoney() != null, ZjkMoneyCollectStatement::getNoPayMoney, bo.getNoPayMoney());
        lqw.eq(bo.getPayMoney() != null, ZjkMoneyCollectStatement::getPayMoney, bo.getPayMoney());
        lqw.eq(bo.getExpertCount() != null, ZjkMoneyCollectStatement::getExpertCount, bo.getExpertCount());
        lqw.eq(bo.getStatementId() != null, ZjkMoneyCollectStatement::getStatementId, bo.getStatementId());
        lqw.eq(StringUtils.isNotBlank(bo.getMoneyCycle()), ZjkMoneyCollectStatement::getMoneyCycle, bo.getMoneyCycle());
        lqw.eq(StringUtils.isNotBlank(bo.getStatus()), ZjkMoneyCollectStatement::getStatus, bo.getStatus());
        return lqw;
    }

    /**
     * 新增报表统计
     *
     * @param bo 报表统计
     * @return 是否新增成功
     */
    @Override
    public Boolean insertByBo(ZjkMoneyCollectStatementBo bo) {
        ZjkMoneyCollectStatement add = MapstructUtils.convert(bo, ZjkMoneyCollectStatement.class);
        validEntityBeforeSave(add);
        boolean flag = baseMapper.insert(add) > 0;
        if (flag) {
            bo.setId(add.getId());
        }
        return flag;
    }

    /**
     * 修改报表统计
     *
     * @param bo 报表统计
     * @return 是否修改成功
     */
    @Override
    public Boolean updateByBo(ZjkMoneyCollectStatementBo bo) {
        ZjkMoneyCollectStatement update = MapstructUtils.convert(bo, ZjkMoneyCollectStatement.class);
        validEntityBeforeSave(update);
        return baseMapper.updateById(update) > 0;
    }

    /**
     * 保存前的数据校验
     */
    private void validEntityBeforeSave(ZjkMoneyCollectStatement entity){
        //TODO 做一些数据校验,如唯一约束
    }

    /**
     * 校验并批量删除报表统计信息
     *
     * @param ids     待删除的主键集合
     * @param isValid 是否进行有效性校验
     * @return 是否删除成功
     */
    @Override
    public Boolean deleteWithValidByIds(Collection<Long> ids, Boolean isValid) {
        if(isValid){
            //TODO 做一些业务上的校验,判断是否需要校验
        }
        return baseMapper.deleteByIds(ids) > 0;
    }
}
