/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.aspect;

import com.alibaba.nacos.config.server.utils.LogUtil;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class ConfigOpFailureAspect {
    private static final Logger LOGGER = LogUtil.DEFAULT_LOG;

    @Pointcut(value="within(com.alibaba.nacos.config.server.service.repository..*)")
    public void configRepositoryInterfaceMethods() {
    }

    @AfterThrowing(pointcut="configRepositoryInterfaceMethods()", throwing="exception")
    public void logException(JoinPoint joinPoint, Throwable exception) {
        try {
            Object[] args = joinPoint.getArgs();
            StringBuilder params = new StringBuilder();
            if (args != null) {
                for (int i = 0; i < args.length; ++i) {
                    if (i < args.length - 1) {
                        params.append(args[i]).append(", ");
                        continue;
                    }
                    params.append(args[i]);
                }
            }
            String methodName = joinPoint.getSignature().getName();
            LOGGER.error("An error occurred while executing method [{}].\n Parameters: [{}].", new Object[]{methodName, params, exception});
        }
        catch (Exception e) {
            LOGGER.error("An error occurred while logging the original exception. method [{}]", (Object)joinPoint.getSignature().getName(), (Object)e);
        }
    }
}

