/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.core.ability.control;

import com.alibaba.nacos.api.ability.constant.AbilityKey;
import com.alibaba.nacos.api.ability.constant.AbilityMode;
import com.alibaba.nacos.api.ability.register.impl.ClusterClientAbilities;
import com.alibaba.nacos.api.ability.register.impl.SdkClientAbilities;
import com.alibaba.nacos.api.ability.register.impl.ServerAbilities;
import com.alibaba.nacos.common.ability.AbstractAbilityControlManager;
import com.alibaba.nacos.sys.env.EnvUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ServerAbilityControlManager
extends AbstractAbilityControlManager {
    protected Map<AbilityMode, Map<AbilityKey, Boolean>> initCurrentNodeAbilities() {
        HashMap<AbilityMode, Map<AbilityKey, Boolean>> res = new HashMap<AbilityMode, Map<AbilityKey, Boolean>>(2);
        res.put(AbilityMode.CLUSTER_CLIENT, this.initClusterClientAbilities());
        res.put(AbilityMode.SDK_CLIENT, this.initSdkClientAbilities());
        Map staticAbilities = ServerAbilities.getStaticAbilities();
        Set abilityKeys = staticAbilities.keySet();
        HashMap abilityTable = new HashMap(abilityKeys.size());
        HashSet unIncludedInConfig = new HashSet();
        abilityKeys.forEach(abilityKey -> {
            String key = "nacos.core.ability." + abilityKey.getName();
            try {
                Boolean property = (Boolean)EnvUtil.getProperty((String)key, Boolean.class);
                if (property != null) {
                    abilityTable.put(abilityKey, property);
                } else {
                    unIncludedInConfig.add(abilityKey);
                }
            }
            catch (Exception e) {
                unIncludedInConfig.add(abilityKey);
            }
        });
        unIncludedInConfig.forEach(abilityKey -> {
            Boolean cfr_ignored_0 = (Boolean)abilityTable.put(abilityKey, staticAbilities.get(abilityKey));
        });
        res.put(AbilityMode.SERVER, abilityTable);
        return res;
    }

    private Map<AbilityKey, Boolean> initClusterClientAbilities() {
        return ClusterClientAbilities.getStaticAbilities();
    }

    private Map<AbilityKey, Boolean> initSdkClientAbilities() {
        return SdkClientAbilities.getStaticAbilities();
    }

    public int getPriority() {
        return 1;
    }
}

