package org.dromara.zjk.controller;

import cn.dev33.satoken.annotation.SaCheckRole;
import cn.dev33.satoken.annotation.SaMode;
import lombok.RequiredArgsConstructor;
import org.dromara.common.core.constant.TenantConstants;
import org.dromara.common.mybatis.core.page.PageQuery;
import org.dromara.common.mybatis.core.page.TableDataInfo;
import org.dromara.common.web.core.BaseController;
import org.dromara.zjk.domain.vo.ZjkSettlementVoucherVO;
import org.dromara.zjk.service.ZjkSettlementVoucherService;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 结算凭证控制器
 *
 * @author ygh
 * @date 2025-07-30
 */
@RequiredArgsConstructor
@RestController
@RequestMapping("/settleCheck")
public class SettlementVoucherController extends BaseController {

    private final ZjkSettlementVoucherService zjkSettlementVoucherService;

    /**
     * 查询结算凭证列表
     */
    @SaCheckRole(value = {
        TenantConstants.JG_ROLE_KEY
    }, mode = SaMode.OR)
    @GetMapping("/list")
    public TableDataInfo<ZjkSettlementVoucherVO> list(ZjkSettlementVoucherVO bo, PageQuery pageQuery) {
        return zjkSettlementVoucherService.queryPageList(bo, pageQuery);
    }


}
