package org.dromara.zjk.domain;

import org.dromara.common.tenant.core.TenantEntity;
import com.baomidou.mybatisplus.annotation.*;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serial;
import java.util.Date;

/**
 * 项目总结对象 zjk_product_summarize
 *
 * @author ygh
 * @date 2024-11-02
 */
@Data
@EqualsAndHashCode(callSuper = true)
@TableName("zjk_product_summarize")
public class ZjkProductSummarize extends TenantEntity {

    @Serial
    private static final long serialVersionUID = 1L;

    /**
     * id
     */
    private Long id;

    /**
     * 专家抽取id
     */
    private Long reviewId;

    /**
     * 总结名称
     */
    private String productSummarizeName;

    /**
     * 总结类型
     */
    private String productSummarizeType;

    /**
     * 项目概况
     */
    private String productGeneral;

    /**
     * 评审范围
     */
    private String reviewScope;

    /**
     * 评审结论
     */
    private String reviewConclusion;

    /**
     * 反馈
     */
    private String feedback;

    /**
     * 后续改进措施
     */
    private String subsequent;

    /**
     * 附件
     */
    private String attachment;

    /**
     * 专家id
     */
    private String expertIds;

    /**
     * 状态
     */
    private String status;

    /**
     * 备注
     */
    private String remark;

    /**
     * 是否删除
     */
    @TableLogic
    private Long delFlag;

    /**
     * 审核时间
     */
    private Date auditTime;

    /**
     * 审核状态
     */
    private String auditStatus;

    /**
     * 审核备注
     */
    private String auditRemark;

    /**
     * 审核人
     */
    private Long auditBy;

    private Long productId;

    private String reviewSn;


}
