package org.dromara.zjk.domain;

import org.dromara.common.tenant.core.TenantEntity;
import com.baomidou.mybatisplus.annotation.*;
import lombok.Data;
import lombok.EqualsAndHashCode;
import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.io.Serial;

/**
 * 项目总结评价对象 zjk_project_evaluation
 *
 * @author ygh
 * @date 2024-11-08
 */
@Data
@EqualsAndHashCode(callSuper = true)
@TableName("zjk_project_evaluation")
public class ZjkProjectEvaluation extends TenantEntity {

    @Serial
    private static final long serialVersionUID = 1L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 项目总结id
     */
    private Long productSummarizeId;

    /**
     * 目标达成
     */
    private Long goalAchievement;

    /**
     * 交付质量
     */
    private Long deliveryQuality;

    /**
     * 成本控制
     */
    private Long costControl;

    /**
     * 风险管理
     */
    private Long riskManagement;

    /**
     * 项目价值
     */
    private Long projectValue;

    /**
     * 项目总结评价文件id集合
     */
    private String evaluateFile;

    /**
     * 项目总结评价
     */
    private String projectSummaryEvaluation;

    private String appraiser;

    private Date appraiserTime;



}
