package org.dromara.zjk.domain.bo;

import org.dromara.zjk.domain.LearningPlan;
import org.dromara.common.mybatis.core.domain.BaseEntity;
import org.dromara.common.core.validate.AddGroup;
import org.dromara.common.core.validate.EditGroup;
import io.github.linpeilie.annotations.AutoMapper;
import lombok.Data;
import lombok.EqualsAndHashCode;
import jakarta.validation.constraints.*;
import java.util.Date;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 【请填写功能名称】业务对象 zjk_learning_plan
 *
 * @author ygh
 * @date 2025-07-28
 */
@Data
@EqualsAndHashCode(callSuper = true)
@AutoMapper(target = LearningPlan.class, reverseConvertGenerate = false)
public class LearningPlanBo extends BaseEntity {

    /**
     * 租户号
     */
    private String ID;

    /**
     * 计划名称;zjk_learning_course主键
     */
    @NotBlank(message = "计划名称;zjk_learning_course主键不能为空", groups = { AddGroup.class, EditGroup.class })
    private String planName;

    /**
     * 计划开始时间
     */
    @NotNull(message = "计划开始时间不能为空", groups = { AddGroup.class, EditGroup.class })
    private Date startTime;

    /**
     * 计划结束时间
     */
    @NotNull(message = "计划结束时间不能为空", groups = { AddGroup.class, EditGroup.class })
    private Date endTime;

    /**
     * 学习目标
     */
    @NotBlank(message = "学习目标不能为空", groups = { AddGroup.class, EditGroup.class })
    private String studyTarget;
    /**
     * 学习课程id
     */
    private List<Long> courseIds;
}
